/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.timeslice;

import edu.iu.nwb.preprocessing.timeslice.MultiTableGroup;
import edu.iu.nwb.preprocessing.timeslice.SingleTableGroup;
import edu.iu.nwb.preprocessing.timeslice.TableGroup;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgi.service.log.LogService;
import prefuse.data.DataTypeException;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.util.collections.IntIterator;

public class Slice
implements Algorithm {
    public static final int MONTHS_PER_QUARTER = 3;
    public static final int YEARS_PER_DECADE = 10;
    public static final int YEARS_PER_CENTURY = 100;
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private LogService logger;
    private static final String DEFAULT_CUSTOM_TIME = "yyyy";
    private static Map<String, DateTimeFieldType> alignmentMap = new HashMap<String, DateTimeFieldType>();
    private static Map<DateTimeFieldType, DateTimeFieldType> dependencyMap = new HashMap<DateTimeFieldType, DateTimeFieldType>();
    private static Map<String, Integer> weekDayMap = new HashMap<String, Integer>();
    private static Map<DateTimeFieldType, Period> rollBackMap = new HashMap<DateTimeFieldType, Period>();
    private static Map<String, Period> periodMap = new HashMap<String, Period>();
    private static Map<String, Period> formatTokenToPeriod = new LinkedHashMap<String, Period>();
    private static Set<String> periodPatternTokens = new HashSet<String>();
    private Period smallestInputPeriodComponent = Period.millis((int)1);
    private DateTimeFormatter format;

    static {
        alignmentMap.put("seconds", DateTimeFieldType.millisOfSecond());
        alignmentMap.put("minutes", DateTimeFieldType.secondOfMinute());
        alignmentMap.put("hours", DateTimeFieldType.minuteOfHour());
        alignmentMap.put("days", DateTimeFieldType.millisOfDay());
        alignmentMap.put("weeks", DateTimeFieldType.dayOfWeek());
        alignmentMap.put("months", DateTimeFieldType.dayOfMonth());
        alignmentMap.put("years", DateTimeFieldType.dayOfYear());
        alignmentMap.put("centuries", DateTimeFieldType.yearOfCentury());
        dependencyMap.put(DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond());
        dependencyMap.put(DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute());
        dependencyMap.put(DateTimeFieldType.dayOfWeek(), DateTimeFieldType.millisOfDay());
        dependencyMap.put(DateTimeFieldType.dayOfMonth(), DateTimeFieldType.millisOfDay());
        dependencyMap.put(DateTimeFieldType.dayOfYear(), DateTimeFieldType.millisOfDay());
        dependencyMap.put(DateTimeFieldType.yearOfCentury(), DateTimeFieldType.dayOfYear());
        weekDayMap.put("saturday", new Integer(6));
        weekDayMap.put("sunday", new Integer(7));
        weekDayMap.put("monday", new Integer(1));
        rollBackMap.put(DateTimeFieldType.dayOfWeek(), Period.weeks((int)1));
        periodMap.put("milliseconds", Period.millis((int)1));
        periodMap.put("seconds", Period.seconds((int)1));
        periodMap.put("minutes", Period.minutes((int)1));
        periodMap.put("hours", Period.hours((int)1));
        periodMap.put("days", Period.days((int)1));
        periodMap.put("weeks", Period.weeks((int)1));
        periodMap.put("months", Period.months((int)1));
        periodMap.put("quarters", Period.months((int)3));
        periodMap.put("years", Period.years((int)1));
        periodMap.put("decades", Period.years((int)10));
        periodMap.put("centuries", Period.years((int)100));
        formatTokenToPeriod.put("S", periodMap.get("milliseconds"));
        formatTokenToPeriod.put("s", periodMap.get("seconds"));
        formatTokenToPeriod.put("m", periodMap.get("minutes"));
        formatTokenToPeriod.put("k", periodMap.get("hours"));
        formatTokenToPeriod.put("H", periodMap.get("hours"));
        formatTokenToPeriod.put("K", periodMap.get("hours"));
        formatTokenToPeriod.put("h", periodMap.get("hours"));
        formatTokenToPeriod.put("d", periodMap.get("days"));
        formatTokenToPeriod.put("D", periodMap.get("days"));
        formatTokenToPeriod.put("E", periodMap.get("days"));
        formatTokenToPeriod.put("e", periodMap.get("days"));
        formatTokenToPeriod.put("w", periodMap.get("weeks"));
        formatTokenToPeriod.put("M", periodMap.get("months"));
        formatTokenToPeriod.put("x", periodMap.get("years"));
        formatTokenToPeriod.put("Y", periodMap.get("years"));
        formatTokenToPeriod.put("y", periodMap.get("years"));
        formatTokenToPeriod.put("C", periodMap.get("centuries"));
        periodPatternTokens.addAll(formatTokenToPeriod.keySet());
    }

    public Slice(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public static void main(String[] ss) throws ParseException {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"dd/MM/yy");
        DateTime date1 = format.parseDateTime("01/12/4");
        DateTime date2 = format.parseDateTime("01/01/-3");
        Years years = Years.yearsBetween((ReadableInstant)date2, (ReadableInstant)date1);
        System.out.println(years.getYears());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table table = (Table)this.data[0].getData();
        String formatString = (String)this.parameters.get("format");
        String dateColumn = (String)this.parameters.get("column");
        String interval = (String)this.parameters.get("interval");
        boolean align = (Boolean)this.parameters.get("align");
        boolean cumulative = (Boolean)this.parameters.get("cumulative");
        String weekStarts = (String)this.parameters.get("weekstarts");
        this.smallestInputPeriodComponent = this.initializeSmallestInputPeriodComponent(formatString);
        this.format = DateTimeFormat.forPattern((String)formatString);
        LocalDateTime[] customYearRange = this.initializeCustomPeriodRange();
        int periodMultiplier = (Integer)this.parameters.get("periodmultiplier");
        if (periodMultiplier <= 0) {
            periodMultiplier = 1;
        }
        Period periodOriginal = periodMap.get(interval);
        Period period = this.multiplyPeriod(periodOriginal, periodMultiplier);
        SortedMap<LocalDateTime, Set<Integer>> byDateTime = this.createDateTimeMap(table, dateColumn);
        TableGroup tables = this.createTableGroup(cumulative);
        LocalDateTime[] recordsExtractionBounds = this.initializeRecordsExtractionBounds(interval, align, weekStarts, period, customYearRange, byDateTime);
        List<List<LocalDateTime>> epochRange = this.accumulateTables(table, period, recordsExtractionBounds, byDateTime, tables, cumulative);
        return this.dataChildrenOf(this.data[0], tables.getTables(), epochRange.get(0).toArray(new LocalDateTime[0]), epochRange.get(1).toArray(new LocalDateTime[0]), period);
    }

    private Period initializeSmallestInputPeriodComponent(String formatString) {
        Period inputPeriodComponent = Period.millis((int)1);
        HashSet<String> inputFormatTokens = new HashSet<String>(Arrays.asList(formatString.split("")));
        inputFormatTokens.retainAll(periodPatternTokens);
        for (String currentFormatToken : formatTokenToPeriod.keySet()) {
            if (!inputFormatTokens.contains(currentFormatToken)) continue;
            inputPeriodComponent = formatTokenToPeriod.get(currentFormatToken);
            break;
        }
        return inputPeriodComponent;
    }

    private LocalDateTime[] initializeCustomPeriodRange() {
        String toTimeString;
        LocalDateTime[] customPeriodRange = new LocalDateTime[2];
        String fromTimeString = (String)this.parameters.get("fromtime");
        if (!DEFAULT_CUSTOM_TIME.equalsIgnoreCase(fromTimeString)) {
            try {
                customPeriodRange[0] = new LocalDateTime((Object)this.format.parseDateTime(fromTimeString));
            }
            catch (IllegalArgumentException e) {
                this.logger.log(2, "Problem parsing " + fromTimeString + ". \"From time\" value " + "format should look like " + this.format.print((ReadableInstant)new DateTime()) + ". Using default \"From time\" value.", (Throwable)e);
            }
        }
        if (!DEFAULT_CUSTOM_TIME.equalsIgnoreCase(toTimeString = (String)this.parameters.get("totime"))) {
            try {
                customPeriodRange[1] = new LocalDateTime((Object)this.format.parseDateTime(toTimeString));
            }
            catch (IllegalArgumentException e) {
                this.logger.log(2, "Problem parsing " + toTimeString + ". \"To time\" value " + "format should look like " + this.format.print((ReadableInstant)new DateTime()) + ". Using default \"To time\" value.", (Throwable)e);
            }
        }
        return customPeriodRange;
    }

    private Period multiplyPeriod(Period periodOriginal, int periodMultiplier) {
        Period period = periodOriginal;
        int ii = 1;
        while (ii < periodMultiplier) {
            period = period.plus((ReadablePeriod)periodOriginal);
            ++ii;
        }
        return period;
    }

    private List<List<LocalDateTime>> accumulateTables(Table table, Period period, LocalDateTime[] recordsExtractionBounds, SortedMap<LocalDateTime, Set<Integer>> byDateTime, TableGroup tables, boolean cumulative) throws AlgorithmExecutionException {
        Schema schema = table.getSchema();
        LocalDateTime current = new LocalDateTime((Object)recordsExtractionBounds[1]);
        ArrayList<LocalDateTime> ends = new ArrayList<LocalDateTime>();
        ArrayList<LocalDateTime> starts = new ArrayList<LocalDateTime>();
        while (current.compareTo((Object)recordsExtractionBounds[0]) > 0) {
            LocalDateTime currentMinus = new LocalDateTime((Object)current.minus((ReadablePeriod)period));
            tables.addTable(schema.instantiate());
            if (currentMinus.compareTo((Object)recordsExtractionBounds[0]) < 0) {
                currentMinus = recordsExtractionBounds[0];
            }
            Collection<Set<Integer>> rowSets = byDateTime.subMap(currentMinus, current).values();
            this.addRowSets(tables, rowSets, table);
            LocalDateTime currentForLabel = current.minus((ReadablePeriod)this.smallestInputPeriodComponent);
            ends.add(currentForLabel);
            if (cumulative) {
                starts.add(recordsExtractionBounds[0]);
            } else {
                starts.add(currentMinus);
            }
            current = currentMinus;
        }
        ArrayList<List<LocalDateTime>> returnRange = new ArrayList<List<LocalDateTime>>();
        returnRange.add(starts);
        returnRange.add(ends);
        return returnRange;
    }

    private LocalDateTime[] initializeRecordsExtractionBounds(String interval, boolean align, String weekStarts, Period period, LocalDateTime[] customYearRange, SortedMap<LocalDateTime, Set<Integer>> byDateTime) throws AlgorithmExecutionException {
        LocalDateTime[] recordsExtractionBounds = new LocalDateTime[2];
        if (customYearRange[1] != null && customYearRange[0] != null && customYearRange[0].compareTo((Object)customYearRange[1]) > 0) {
            recordsExtractionBounds[0] = this.realMin(byDateTime, interval, align, weekStarts);
            recordsExtractionBounds[1] = this.realMax(byDateTime);
            throw new AlgorithmExecutionException("\"From year\" value cannot be more than \"To year\" value.");
        }
        recordsExtractionBounds[0] = customYearRange[0] != null ? customYearRange[0] : this.realMin(byDateTime, interval, align, weekStarts);
        recordsExtractionBounds[1] = customYearRange[1] != null ? customYearRange[1] : this.realMax(byDateTime);
        recordsExtractionBounds[1] = recordsExtractionBounds[1].plus((ReadablePeriod)this.smallestInputPeriodComponent);
        return recordsExtractionBounds;
    }

    private Data[] dataChildrenOf(Data parent, Table[] tables, LocalDateTime[] starts, LocalDateTime[] ends, Period period) {
        Data[] output = new Data[tables.length];
        int ii = 0;
        while (ii < output.length) {
            BasicData data = new BasicData((Object)tables[ii], Table.class.getName());
            data = this.updateProperties((Data)data, parent, starts[ii], ends[ii], tables[ii].getRowCount(), period);
            output[ii] = data;
            ++ii;
        }
        return output;
    }

    private Data updateProperties(Data data, Data parent, LocalDateTime start, LocalDateTime end, int rowCount, Period period) {
        Dictionary metadata = data.getMetadata();
        metadata.put("Label", "slice from beginning of " + this.format.print((ReadablePartial)start) + " to end of " + this.format.print((ReadablePartial)end) + " (" + rowCount + " records)");
        metadata.put("Parent", parent);
        metadata.put("Type", "Table");
        return data;
    }

    private TableGroup createTableGroup(boolean cumulative) {
        if (cumulative) {
            return new MultiTableGroup();
        }
        return new SingleTableGroup();
    }

    private void addRowSets(TableGroup tables, Collection<Set<Integer>> rowSets, Table table) {
        for (Set<Integer> idSet : rowSets) {
            this.addRows(tables, idSet, table);
        }
    }

    private void addRows(TableGroup tables, Set<Integer> idSet, Table table) {
        for (int id : idSet) {
            tables.addTupleToAll(table.getTuple(id));
        }
    }

    private LocalDateTime realMax(SortedMap<LocalDateTime, Set<Integer>> byDateTime) {
        LocalDateTime max = byDateTime.lastKey();
        return max;
    }

    private LocalDateTime realMin(SortedMap<LocalDateTime, Set<Integer>> byDateTime, String interval, boolean align, String weekStarts) {
        LocalDateTime min = byDateTime.firstKey();
        if (align) {
            min = this.truncate(min, interval, weekStarts);
        }
        return min;
    }

    private LocalDateTime truncate(LocalDateTime min, String interval, String weekStarts) {
        if (!alignmentMap.containsKey(interval)) {
            this.logger.log(2, String.valueOf(interval) + " cannot be aligned with the calendar; " + "proceeding without alignment.");
            return min;
        }
        DateTimeFieldType fieldType = alignmentMap.get(interval);
        min = this.rollBackMainField(min, fieldType, weekStarts);
        min = this.zeroOut(min, fieldType);
        return min;
    }

    private LocalDateTime rollBackMainField(LocalDateTime min, DateTimeFieldType fieldType, String weekStarts) {
        int firstValue = this.getFirstValue(fieldType, weekStarts);
        if (firstValue > min.get(fieldType)) {
            Period rollBack = rollBackMap.get(fieldType);
            min = min.minus((ReadablePeriod)rollBack);
        }
        return min.withField(fieldType, firstValue);
    }

    private LocalDateTime zeroOut(LocalDateTime min, DateTimeFieldType fieldType) {
        while (dependencyMap.containsKey(fieldType)) {
            fieldType = dependencyMap.get(fieldType);
            min = min.withField(fieldType, 0);
        }
        return min;
    }

    private int getFirstValue(DateTimeFieldType fieldType, String weekStarts) {
        if (DateTimeFieldType.dayOfWeek().equals(fieldType)) {
            return weekDayMap.get(weekStarts);
        }
        return 1;
    }

    private SortedMap<LocalDateTime, Set<Integer>> createDateTimeMap(Table table, String dateColumn) throws AlgorithmExecutionException {
        TreeMap<LocalDateTime, Set<Integer>> byDateTime = new TreeMap<LocalDateTime, Set<Integer>>();
        IntIterator ids = table.rows();
        while (ids.hasNext()) {
            LocalDateTime dateTime;
            int id = ids.nextInt();
            String dateTimeString = null;
            try {
                dateTimeString = table.get(id, dateColumn).toString().trim();
                dateTime = new LocalDateTime((Object)this.format.parseDateTime(dateTimeString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    dateTime = new LocalDateTime((Object)dateTimeString);
                }
                catch (DataTypeException dateTypeException) {
                    throw new AlgorithmExecutionException("Problem parsing " + dateTimeString, (Throwable)dateTypeException);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new AlgorithmExecutionException("Problem parsing " + dateTimeString + ". Date time values for that format should look like " + this.format.print((ReadableInstant)new DateTime()) + ".", (Throwable)illegalArgumentException2);
                }
            }
            if (!byDateTime.containsKey(dateTime)) {
                byDateTime.put(dateTime, new HashSet());
            }
            ((Set)byDateTime.get(dateTime)).add(new Integer(id));
        }
        return byDateTime;
    }
}

