/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.preprocessing.trimedges;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Random;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.Sort;
import prefuse.data.util.TableIterator;

public class Trim
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public Trim(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        Graph graph = (Graph)this.data[0].getData();
        int leave = (Integer)this.parameters.get("leave");
        Table nodeTable = graph.getNodeTable().getSchema().instantiate();
        Table edgeTable = graph.getEdgeTable().getSchema().instantiate();
        graph.getEdgeSourceField();
        graph.getEdgeTargetField();
        graph.getNodeKeyField();
        TableIterator nodes = graph.getNodeTable().iterator();
        while (nodes.hasNext()) {
            nodeTable.addTuple(graph.getNodeTable().getTuple(((Integer)nodes.next()).intValue()));
        }
        TableIterator edges = graph.getEdgeTable().iterator();
        while (edges.hasNext()) {
            Tuple tuple = graph.getEdgeTable().getTuple(((Integer)edges.next()).intValue());
            edgeTable.addTuple(tuple);
        }
        final Graph resultGraph = new Graph(nodeTable, edgeTable, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        Table sorted = resultGraph.getNodeTable().select((Predicate)BooleanLiteral.TRUE, new Sort(){

            public Comparator getComparator(TupleSet ts) {
                return new Comparator(){

                    public int compare(Object one, Object two) {
                        int secondDegree;
                        Tuple first = (Tuple)one;
                        Tuple second = (Tuple)two;
                        int firstDegree = resultGraph.getDegree(first.getRow());
                        if (firstDegree < (secondDegree = resultGraph.getDegree(second.getRow()))) {
                            return -1;
                        }
                        if (firstDegree > secondDegree) {
                            return 1;
                        }
                        return 0;
                    }
                };
            }
        });
        Random randomizer = new Random();
        Iterator iter = sorted.tuplesReversed();
        while (iter.hasNext()) {
            Tuple tuple = (Tuple)iter.next();
            Node node = resultGraph.getNode(tuple.getRow());
            ArrayList connected = new ArrayList();
            Iterator connectedIter = node.edges();
            while (connectedIter.hasNext()) {
                connected.add(connectedIter.next());
            }
            while (node.getDegree() > leave) {
                Edge removed = (Edge)connected.remove(randomizer.nextInt(connected.size()));
                resultGraph.removeEdge(removed);
            }
        }
        BasicData result = new BasicData((Object)resultGraph, Graph.class.getName());
        Dictionary metadata = result.getMetadata();
        metadata.put("Label", "Degree reduced to " + leave);
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Network");
        return new Data[]{result};
    }
}

