/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.shared.isiutil;

import edu.iu.nwb.shared.isiutil.ContentType;
import edu.iu.nwb.shared.isiutil.ISITag;
import edu.iu.nwb.shared.isiutil.exception.ReadTableException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.cishell.utilities.UnicodeReader;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.util.collections.IntIterator;

public class ISITableReader {
    public static final String NORMALIZED_SEPARATOR = "|";
    public static final String NORMALIZED_SEPARATOR_REGEX = "\\|";
    public static final int MIN_TAG_LENGTH = 2;
    public static final String FILE_PATH_COLUMN_NAME = "File Name";
    private String versionNumber = "";
    private FileVersion isiVersion = FileVersion.UNKNOWN;
    private LogService log;
    private boolean normalizeAuthorNames;
    private String fileType = "";
    private static final String LOOKS_LIKE_A_DOI = "10\\..*";

    public ISITableReader(LogService log, boolean normalizeAuthorNames) {
        this.log = log;
        this.normalizeAuthorNames = normalizeAuthorNames;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public Table readTable(String originalFileName, File file) throws IOException, ReadTableException {
        return this.readTable(originalFileName, file, false);
    }

    public Table readTable(String originalFileName, File file, boolean shouldFillFileMetadata) throws IOException, ReadTableException {
        return this.readTable(originalFileName, file, shouldFillFileMetadata, true);
    }

    public Table readTable(String originalFileName, File file, boolean shouldFillFileMetadata, boolean shouldClean) throws IOException, ReadTableException {
        BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(file)));
        TableData tableData = this.generateEmptyISITable();
        String currentLine = ISITableReader.moveToNextLineWithTag(reader);
        while (currentLine != null) {
            String currentTagName = this.extractTagName(currentLine);
            ISITag currentTag = this.getOrCreateNewTag(currentTagName, tableData);
            if (currentTag.equals(ISITag.END_OF_FILE)) {
                currentLine = ISITableReader.moveToNextLineWithTag(reader);
                continue;
            }
            if (currentTag.equals(ISITag.END_OF_RECORD)) {
                tableData.moveOnToNextRow();
                currentLine = ISITableReader.moveToNextLineWithTag(reader);
                continue;
            }
            if (currentTag.equals(ISITag.FILE_TYPE)) {
                this.setFileType(this.extractTagValue(currentLine));
                currentLine = ISITableReader.moveToNextLineWithTag(reader);
                continue;
            }
            if (currentTag.equals(ISITag.VERSION_NUMBER)) {
                this.versionNumber = this.extractTagValue(currentLine);
                currentLine = ISITableReader.moveToNextLineWithTag(reader);
                continue;
            }
            if (currentTag.type.equals(ContentType.INTEGER)) {
                currentLine = this.addIntTagData(currentTag, currentLine, reader, tableData, shouldClean);
                continue;
            }
            if (currentTag.type.equals(ContentType.TEXT)) {
                currentLine = this.addStringTagData(currentTag, currentLine, reader, tableData, shouldClean);
                continue;
            }
            if (currentTag.type.equals(ContentType.MULTI_VALUE_TEXT)) {
                currentLine = this.addMultivalueTagData(currentTag, currentLine, reader, tableData, shouldClean);
                continue;
            }
            String logMessage = "No case in ISITableReader to handle the tag " + currentTag.columnName + ".  Moving on to next tag.";
            this.log.log(2, logMessage);
            currentLine = ISITableReader.moveToNextLineWithTag(reader);
        }
        Table constructedTable = tableData.getTable();
        if (shouldFillFileMetadata) {
            this.fillFileMetadata(constructedTable, originalFileName);
        }
        return constructedTable;
    }

    private void setFileType(String fileType) {
        this.fileType = fileType;
        if (this.fileType.toLowerCase().contains("isi")) {
            this.isiVersion = FileVersion.OLD;
            this.log.log(3, "Found old-style ISI/Web Of Knowledge file.");
        } else if (this.fileType.toLowerCase().contains("web of knowledge")) {
            this.isiVersion = FileVersion.NEW_2011;
            this.log.log(3, "Found new-style ISI/Web Of Knowledge file.");
        } else {
            this.isiVersion = FileVersion.UNKNOWN;
            this.log.log(2, "New ISI/Web of Knowledge file type?  " + fileType);
        }
    }

    private String addIntTagData(ISITag currentTag, String currentLine, BufferedReader reader, TableData tableData, boolean shouldClean) throws IOException, ReadTableException {
        String tagValue = this.extractTagValue(currentLine);
        try {
            int intValue = Integer.parseInt(tagValue);
            tableData.setInt(currentTag.columnName, intValue);
            String nextLine = ISITableReader.moveToNextLineWithTag(reader);
            return nextLine;
        }
        catch (NumberFormatException e) {
            String logMessage = "WARNING: Tag '" + currentTag + "' " + "with data '" + tagValue + "' could not be parsed as an integer.  " + "Treating the data as text instead";
            this.log.log(2, logMessage, (Throwable)e);
            return this.addMultivalueTagData(currentTag, tagValue, reader, tableData, shouldClean);
        }
    }

    private String addStringTagData(ISITag currentTag, String currentLine, BufferedReader reader, TableData tableData, boolean shouldClean) throws IOException, ReadTableException {
        return this.processMultilineTagDataNormally(currentTag, currentLine, reader, tableData, shouldClean);
    }

    private String addMultivalueTagData(ISITag currentTag, String currentLine, BufferedReader reader, TableData tableData, boolean shouldClean) throws IOException, ReadTableException {
        String nextLine;
        String separator = currentTag.separator;
        if (separator == null) {
            this.log.log(2, "Programmer error: multi-value text tag not provided with separator");
            nextLine = ISITableReader.moveToNextLineWithTag(reader);
        } else {
            nextLine = separator.equals("\n") ? this.processMultilineTagDataWithNewlineSeparators(currentTag, currentLine, reader, tableData, shouldClean) : (separator.equals(";\n") ? this.processMultilineTagDataWithNewlineAndSeparators(currentTag, currentLine, reader, tableData, ";", shouldClean) : this.processMultilineTagDataWithNonNewlineSeparators(currentTag, currentLine, reader, tableData, separator, shouldClean));
        }
        return nextLine;
    }

    private String processMultilineTagDataNormally(ISITag currentTag, String currentLine, BufferedReader reader, TableData table, boolean shouldClean) throws IOException, ReadTableException {
        return this.processMultilineTagData(currentTag, currentLine, reader, table, " ", null, shouldClean);
    }

    private String processMultilineTagDataWithNewlineSeparators(ISITag currentTag, String currentLine, BufferedReader reader, TableData table, boolean shouldClean) throws IOException, ReadTableException {
        return this.processMultilineTagData(currentTag, currentLine, reader, table, NORMALIZED_SEPARATOR, null, shouldClean);
    }

    private String processMultilineTagDataWithNonNewlineSeparators(ISITag currentTag, String currentLine, BufferedReader reader, TableData table, String separator, boolean shouldClean) throws IOException, ReadTableException {
        return this.processMultilineTagData(currentTag, currentLine, reader, table, " ", separator, shouldClean);
    }

    private String processMultilineTagDataWithNewlineAndSeparators(ISITag currentTag, String currentLine, BufferedReader reader, TableData table, String separator, boolean shouldClean) throws IOException, ReadTableException {
        return this.processMultilineTagData(currentTag, currentLine, reader, table, NORMALIZED_SEPARATOR, separator, shouldClean);
    }

    private String processMultilineTagData(ISITag currentTag, String currentLine, BufferedReader reader, TableData tableData, String stringToReplaceNewLine, String separatorString, boolean shouldClean) throws IOException, ReadTableException {
        currentLine = this.removeTag(currentLine);
        StringBuffer stringSoFar = new StringBuffer();
        do {
            currentLine = currentLine.trim();
            if (currentTag.equals(ISITag.CITED_REFERENCES) && currentLine.matches(LOOKS_LIKE_A_DOI)) {
                stringSoFar.append(" ");
            } else {
                if (shouldClean) {
                    currentLine = this.tagSpecificProcessing(currentTag, currentLine);
                }
                stringSoFar.append(stringToReplaceNewLine);
            }
            stringSoFar.append(currentLine);
        } while ((currentLine = ISITableReader.moveToNextNonEmptyLine(reader)).startsWith("  "));
        stringSoFar.delete(0, stringToReplaceNewLine.length());
        String allTagDataString = stringSoFar.toString();
        if (separatorString != null) {
            allTagDataString = ISITableReader.replaceSeparatorsWithNewSeparators(allTagDataString, separatorString, NORMALIZED_SEPARATOR, NORMALIZED_SEPARATOR_REGEX);
        }
        try {
            tableData.setString(currentTag.columnName, allTagDataString);
        }
        catch (Exception e) {
            this.log.log(3, "currentTag name: " + currentTag.columnName + "\n" + "currentTag type: " + currentTag.type + "\n" + "allTagDataString: " + allTagDataString, (Throwable)e);
            throw new ReadTableException("Error occurred while setting table data: " + e.getMessage(), e);
        }
        String nextLineAfterThisTag = currentLine;
        return nextLineAfterThisTag;
    }

    private String[] splitTagLine(String line) {
        String[] lineParts = new String[]{"", ""};
        if (line != null && line.length() >= 2) {
            lineParts = line.split(" ", 2);
        } else {
            this.log.log(2, "Invalid line in isi file. Could not extract tag from line \r\n" + line + "\nSkipping line...");
        }
        return lineParts;
    }

    private String extractTagName(String line) {
        return this.splitTagLine(line)[0];
    }

    private String extractTagValue(String lineWithTag) {
        String lineWithoutTag = this.removeTag(lineWithTag);
        return lineWithoutTag.trim();
    }

    private static String moveToNextLineWithTag(BufferedReader reader) throws IOException {
        String nextNonEmptyLine;
        while ((nextNonEmptyLine = ISITableReader.moveToNextNonEmptyLine(reader)) != null) {
            if (!ISITableReader.startsWithTag(nextNonEmptyLine)) continue;
            return nextNonEmptyLine;
        }
        return null;
    }

    private static String moveToNextNonEmptyLine(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!line.equals("") && !line.equals("\n") && !line.equals("\r") && !line.equals("\r\n")) break;
        }
        return line;
    }

    private String removeTag(String line) {
        return this.splitTagLine(line)[1];
    }

    private ISITag getOrCreateNewTag(String tagName, TableData tableData) {
        ISITag getTagResult = ISITag.getTag(tagName);
        if (getTagResult != null) {
            return getTagResult;
        }
        this.log.log(2, "Unrecognized tag '" + tagName + "' found in ISI import. " + "The new tag will be parsed into Sci2 as is.");
        ContentType currentTagContentType = ContentType.TEXT;
        ISITag.addArbitraryTag(tagName, tagName, currentTagContentType);
        tableData.addColumn(ISITag.getColumnName(tagName), currentTagContentType.getTableDataType());
        return ISITag.getTag(tagName);
    }

    private static boolean startsWithTag(String potentialTag) {
        return potentialTag.length() >= 2 && !Character.isWhitespace(potentialTag.charAt(0)) && !Character.isWhitespace(potentialTag.charAt(1));
    }

    private String tagSpecificProcessing(ISITag tag, String line) {
        String processedLine;
        if (tag.equals(ISITag.AUTHORS)) {
            if (this.normalizeAuthorNames) {
                processedLine = ISITableReader.processAuthorLine(line);
                this.log.log(4, "Author names from the '" + ISITag.AUTHORS + "' field have been normalized by capitalizing the first letter of all but the last word in the author's name.");
            } else {
                processedLine = line;
            }
        } else if (tag.equals(ISITag.CITED_REFERENCES)) {
            if (this.normalizeAuthorNames) {
                String processedAuthorField;
                String[] fields = line.split(",");
                if (fields.length == 0) {
                    String logMessage = "Skipping this line because no fields were found: " + line;
                    this.log.log(2, logMessage);
                    return line;
                }
                String authorField = fields[0];
                fields[0] = processedAuthorField = ISITableReader.processAuthorLine(authorField);
                processedLine = ISITableReader.joinOver(fields, ",");
                this.log.log(4, "Author names from the '" + ISITag.CITED_REFERENCES + "' field have been normalized by capitalizing the first letter of all but the last word in the author's name.");
            } else {
                processedLine = line;
            }
        } else {
            processedLine = line;
        }
        return processedLine;
    }

    private static String replaceSeparatorsWithNewSeparators(String originalString, String originalSeperator, String newSeparator, String newSeparatorRegex) {
        originalString = originalString.replaceAll(originalSeperator, newSeparator);
        String[] words = originalString.split(newSeparatorRegex);
        int ii = 0;
        while (ii < words.length) {
            words[ii] = words[ii].trim();
            ++ii;
        }
        return ISITableReader.joinOver(words, newSeparator);
    }

    private static String processAuthorLine(String line) {
        String[] words = line.split(" ");
        int ii = 0;
        while (ii < words.length - 1) {
            words[ii] = ISITableReader.capitalizeOnlyFirstLetter(words[ii]);
            ++ii;
        }
        return ISITableReader.joinOver(words, " ");
    }

    private static String capitalizeOnlyFirstLetter(String s) {
        if (s.length() > 0) {
            return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1).toLowerCase();
        }
        return s;
    }

    private static String joinOver(String[] parts, String joiner) {
        StringBuffer joinBuilder = new StringBuffer();
        int ii = 0;
        while (ii < parts.length) {
            if (!parts[ii].isEmpty()) {
                joinBuilder.append(parts[ii]);
                if (ii < parts.length - 1) {
                    joinBuilder.append(joiner);
                }
            }
            ++ii;
        }
        return joinBuilder.toString();
    }

    private TableData generateEmptyISITable() {
        Schema isiTableSchema = new Schema();
        ISITag[] isiTagsAlphabetically = ISITag.getTagsAlphabetically();
        int ii = 0;
        while (ii < isiTagsAlphabetically.length) {
            ISITag tag = isiTagsAlphabetically[ii];
            Class<?> tagTableDataType = tag.type.getTableDataType();
            if (tagTableDataType != null) {
                isiTableSchema.addColumn(tag.columnName, tagTableDataType);
            }
            ++ii;
        }
        TableData emptyISITable = new TableData(isiTableSchema);
        return emptyISITable;
    }

    private void fillFileMetadata(Table table, String absoluteFilePath) {
        table.addColumn(FILE_PATH_COLUMN_NAME, String.class, (Object)absoluteFilePath);
        int fileTypeColumnIndex = table.getColumnNumber(ISITag.FILE_TYPE.getColumnName());
        int versionNumberColumnIndex = table.getColumnNumber(ISITag.VERSION_NUMBER.getColumnName());
        IntIterator rows = table.rows();
        while (rows.hasNext()) {
            Tuple row = table.getTuple(rows.nextInt());
            row.setString(fileTypeColumnIndex, this.fileType);
            row.setString(versionNumberColumnIndex, this.versionNumber);
        }
    }

    public static enum FileVersion {
        OLD,
        NEW_2011,
        UNKNOWN;

    }

    private class TableData {
        private Table table;
        private int currentRow;
        private boolean currentRowIsFinished;

        public TableData(Schema schema) {
            this.table = schema.instantiate();
            this.currentRowIsFinished = true;
        }

        public void moveOnToNextRow() {
            this.currentRowIsFinished = true;
        }

        public void setInt(String columnTag, int value) {
            this.ensureRowNotFinishedYet();
            this.table.setInt(this.currentRow, columnTag, value);
        }

        public void setString(String columnTag, String value) {
            this.ensureRowNotFinishedYet();
            this.table.setString(this.currentRow, columnTag, value);
        }

        public void addColumn(String columnName, Class<?> columnType) {
            this.table.addColumn(columnName, columnType);
        }

        public Table getTable() {
            return this.table;
        }

        private void ensureRowNotFinishedYet() {
            if (this.currentRowIsFinished) {
                this.currentRow = this.table.addRow();
                this.currentRowIsFinished = false;
            }
        }
    }
}

