/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.templates.staticexecutable.nwb;

import edu.iu.nwb.templates.staticexecutable.nwb.NWBIntegrator;
import edu.iu.nwb.templates.staticexecutable.nwb.NWBSimplifier;
import edu.iu.nwb.util.nwbfile.GetMetadataAndCounts;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.templates.staticexecutable.StaticExecutableAlgorithmFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public class Helper
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;
    private StaticExecutableAlgorithmFactory staticAlgorithmFactory;
    private LogService logger;

    public Helper(Data[] data, Dictionary parameters, CIShellContext context, ComponentContext componentContext) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.staticAlgorithmFactory = new StaticExecutableAlgorithmFactory((String)componentContext.getProperties().get("Algorithm-Directory"), componentContext.getBundleContext());
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File nwbFile = (File)this.data[0].getData();
        GetMetadataAndCounts handler = new GetMetadataAndCounts();
        String weightAttribute = (String)this.parameters.get("weightAttribute");
        boolean ignoreWeightAttribute = "Treat all edges as weight one.".equals(weightAttribute);
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)handler);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Problem reading the input file.", (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Invalid input file.", (Throwable)e);
        }
        int nodeCount = handler.getNodeCount();
        int undirectedEdgeCount = handler.getUndirectedEdgeCount();
        int directedEdgeCount = handler.getDirectedEdgeCount();
        if (undirectedEdgeCount != 0 && directedEdgeCount != 0) {
            throw new AlgorithmExecutionException("This network has both directed and undirected edges. That combination is not allowed by this algorithm. Consider transforming the network into one that is all directed or all undirected, perhaps with symmetrize.");
        }
        if (undirectedEdgeCount == 0 && directedEdgeCount == 0) {
            throw new AlgorithmExecutionException("This network has no edges. This algorithm only works on networks with edges.");
        }
        if (directedEdgeCount != 0) {
            throw new AlgorithmExecutionException("This network is directed, but this algorithm only works on undirected networks. Consider using symmetrize or another method to transform the network into an undirected one.");
        }
        try {
            File simpleFormat = File.createTempFile("nwb-", ".simple");
            FileOutputStream simpleOutputStream = new FileOutputStream(simpleFormat);
            NWBSimplifier simplifier = new NWBSimplifier(simpleOutputStream, nodeCount, undirectedEdgeCount + directedEdgeCount, weightAttribute, ignoreWeightAttribute);
            new NWBFileParser(nwbFile).parse((NWBFileParserHandler)simplifier);
            if (simplifier.hadIssue()) {
                throw new AlgorithmExecutionException(simplifier.getReason());
            }
            simpleOutputStream.flush();
            simpleOutputStream.close();
            BasicData simpleData = new BasicData(this.data[0].getMetadata(), (Object)simpleFormat, null);
            Algorithm realAlgorithm = this.staticAlgorithmFactory.createAlgorithm(new Data[]{simpleData}, this.parameters, this.context);
            ArrayList<Object> transformedOutput = new ArrayList<Object>();
            ArrayList<Object> forNodes = new ArrayList<Object>();
            ArrayList<Object> forEdges = new ArrayList<Object>();
            Data[] output = realAlgorithm.execute();
            Data firstAttributeData = null;
            int ii = 0;
            while (ii < output.length) {
                Data outputData = output[ii];
                String fileName = ((File)outputData.getData()).getName();
                if (fileName.endsWith(".nodes")) {
                    forNodes.add(outputData.getData());
                    if (firstAttributeData == null) {
                        firstAttributeData = outputData;
                    }
                } else if (fileName.endsWith(".edges")) {
                    forEdges.add(outputData.getData());
                    if (firstAttributeData == null) {
                        firstAttributeData = outputData;
                    }
                } else {
                    transformedOutput.add(outputData);
                }
                ++ii;
            }
            if (firstAttributeData != null) {
                File realFormat = File.createTempFile("nwb-", ".nwb");
                FileOutputStream realOutputStream = new FileOutputStream(realFormat);
                try {
                    NWBIntegrator integrator = new NWBIntegrator(realOutputStream, forNodes, forEdges);
                    new NWBFileParser(nwbFile).parse((NWBFileParserHandler)integrator);
                }
                catch (IllegalArgumentException e) {
                    throw new AlgorithmExecutionException(e.getMessage(), e.getCause());
                }
                realOutputStream.close();
                BasicData nwbOutput = new BasicData(firstAttributeData.getMetadata(), (Object)realFormat, "file:text/nwb");
                transformedOutput.add(0, nwbOutput);
            }
            return transformedOutput.toArray(new Data[0]);
        }
        catch (IOException iOException) {
            throw new AlgorithmExecutionException("Problems processing the input.");
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Invalid input file.", (Throwable)e);
        }
    }
}

