/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.templates.staticexecutable.nwb;

import edu.iu.nwb.templates.staticexecutable.nwb.Helper;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.DataValidator;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class HelperFactory
implements AlgorithmFactory,
DataValidator,
ParameterMutator {
    protected static final String DEFAULT_WEIGHT = "Treat all edges as weight one.";
    private ComponentContext componentContext;

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        return new Helper(data, parameters, ciShellContext, this.componentContext);
    }

    public String validate(Data[] data) {
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata handler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)handler);
        }
        catch (IOException iOException) {
            return "Unable to read NWB file.";
        }
        catch (ParsingException parsingException) {
            return "Invalid NWB file format.";
        }
        return "";
    }

    private String[] createKeyArray(Map<String, String> schema) {
        ArrayList<String> goodkeys = new ArrayList<String>();
        for (String key : schema.keySet()) {
            if (schema.get(key).equals("string") || "source".equals(key) || "target".equals(key)) continue;
            goodkeys.add(key);
        }
        goodkeys.add(DEFAULT_WEIGHT);
        Collections.reverse(goodkeys);
        return goodkeys.toArray(new String[0]);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata handler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)handler);
        }
        catch (IOException iOException) {
            return oldParameters;
        }
        catch (ParsingException parsingException) {
            return oldParameters;
        }
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        LinkedHashMap undirectedEdgeSchema = handler.getUndirectedEdgeSchema();
        System.err.println("undirectedEdgeSchema: " + undirectedEdgeSchema);
        if (undirectedEdgeSchema == null || undirectedEdgeSchema.keySet().size() == 0) {
            Dictionary properties = this.componentContext.getProperties();
            Object labelObject = properties.get("label");
            if (labelObject == null && (labelObject = properties.get("service.pid")) == null) {
                labelObject = "This algorithm";
            }
            String label = labelObject.toString();
            String exceptionMessage = String.format("%s expects undirected edges, but none were found.", label);
            throw new AlgorithmCreationFailedException(exceptionMessage);
        }
        String[] edgeAttributesArray = this.createKeyArray(undirectedEdgeSchema);
        AttributeDefinition[] definitions = oldParameters.getAttributeDefinitions(-1);
        newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition("weightAttribute", "Weight Attribute", "The attribute to use for weight", 1, edgeAttributesArray, edgeAttributesArray));
        AttributeDefinition[] attributeDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition definition = attributeDefinitionArray[n2];
            if (!"DROPALWAYS".equals(definition.getName())) {
                newParameters.addAttributeDefinition(1, definition);
            }
            ++n2;
        }
        return newParameters;
    }
}

