/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.templates.staticexecutable.nwb;

import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class NWBSimplifier
extends NWBFileParserAdapter {
    private static final String NON_POSITIVE_WEIGHT_REASON = "Non-positive weights are not allowed. To use this algorithm, preprocess your network further.";
    private static final String ISOLATES_REASON = "This algorithm doesn't work on networks with isolates. To use this algorithm, please remove the isolates.";
    private int nodeCount = 0;
    private PrintWriter output;
    private Map nodeIds = new HashMap();
    private String weightAttribute;
    private boolean ignoreWeightAttribute;
    private String reason = "";
    private boolean haltParsing = false;
    private boolean[] nodesParticipating;

    public NWBSimplifier(OutputStream outputStream, int numberOfNodes, int numberOfEdges, String weightAttribute, boolean ignoreWeightAttribute) {
        this.output = new PrintWriter(outputStream, true);
        this.writeHeader(this.output, numberOfNodes, numberOfEdges);
        this.weightAttribute = weightAttribute;
        this.ignoreWeightAttribute = ignoreWeightAttribute;
        this.nodesParticipating = new boolean[numberOfNodes];
    }

    public void addNode(int id, String label, Map attributes) {
        this.nodeIds.put(new Integer(id), new Integer(this.nodeCount));
        ++this.nodeCount;
    }

    private void writeHeader(PrintWriter output, int numberOfNodes, int numberOfEdges) {
        this.output.println(numberOfNodes);
        this.output.println(numberOfEdges);
    }

    private void writeEdge(PrintWriter output, int source, int target, double value) {
        this.output.print(source);
        this.output.print(" ");
        this.output.print(target);
        this.output.print(" ");
        this.output.println(value);
    }

    private void addEdge(int source, int target, double value) {
        int fakeSource = (Integer)this.nodeIds.get(new Integer(source));
        int fakeTarget = (Integer)this.nodeIds.get(new Integer(target));
        this.nodesParticipating[fakeSource] = true;
        this.nodesParticipating[fakeTarget] = true;
        this.writeEdge(this.output, fakeSource, fakeTarget, value);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        double weight = this.ignoreWeightAttribute ? 1.0 : ((Number)attributes.get(this.weightAttribute)).doubleValue();
        if (weight <= 0.0) {
            this.reason = NON_POSITIVE_WEIGHT_REASON;
            this.haltParsing = true;
        } else {
            this.addEdge(sourceNode, targetNode, weight);
        }
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.addDirectedEdge(node1, node2, attributes);
    }

    public void finishedParsing() {
        int ii = 0;
        while (ii < this.nodesParticipating.length) {
            if (!this.nodesParticipating[ii]) {
                this.reason = ISOLATES_REASON;
            }
            ++ii;
        }
    }

    public boolean haltParsingNow() {
        return this.haltParsing;
    }

    public boolean hadIssue() {
        return !"".equals(this.reason);
    }

    public String getReason() {
        return this.reason;
    }
}

