/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.toolkit.networkanalysis;

import edu.iu.nwb.toolkit.networkanalysis.analysis.NetworkProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;

public class ToolkitAlgorithm
implements Algorithm {
    private Data inputData;
    private LogService logger;

    public ToolkitAlgorithm(Data[] data, CIShellContext ciShellContext) {
        this.inputData = data[0];
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Graph netGraph = (Graph)this.inputData.getData();
        StringBuffer log = NetworkProperties.calculateNetworkProperties(netGraph);
        this.logger.log(3, log.toString());
        File logFile = this.logToFile(log);
        Data outputData = this.createOutputData(logFile);
        return new Data[]{outputData};
    }

    private Data createOutputData(File logFile) {
        BasicData outputData = new BasicData((Object)logFile, logFile.getClass().getName());
        Dictionary logAttributes = outputData.getMetadata();
        logAttributes.put("Modified", Boolean.TRUE);
        logAttributes.put("Parent", this.inputData);
        logAttributes.put("Type", "Text");
        logAttributes.put("Label", "Graph and Network Analysis Log");
        return outputData;
    }

    private File logToFile(StringBuffer logInfo) throws AlgorithmExecutionException {
        try {
            File logFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"toolkitErrorLog", (String)"txt");
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logFile)), true);
            writer.write(logInfo.toString());
            writer.close();
            return logFile;
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException("Unable to generate a log file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Unable to generate a log file.", (Throwable)e);
        }
    }

    public static class Factory
    implements AlgorithmFactory {
        public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext ciShellContext) {
            return new ToolkitAlgorithm(data, ciShellContext);
        }
    }
}

