/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.toolkit.networkanalysis.analysis;

import edu.iu.nwb.toolkit.networkanalysis.analysis.EdgeStats;
import edu.iu.nwb.toolkit.networkanalysis.analysis.NodeStats;
import edu.iu.nwb.toolkit.networkanalysis.analysis.StrongComponentClusteringThread;
import edu.iu.nwb.toolkit.networkanalysis.analysis.WeakComponentClusteringThread;
import java.text.DecimalFormat;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import prefuse.data.Graph;

public class NetworkProperties {
    private static final String LINE_SEP = System.getProperty("line.separator");
    public static final DecimalFormat roundedStatisticsFormatter = new DecimalFormat("#.####");

    public static StringBuffer calculateNetworkProperties(Graph graph) throws AlgorithmExecutionException {
        boolean isDirectedGraph = graph.isDirected();
        StringBuffer output = new StringBuffer();
        NodeStats nodeStats = NodeStats.constructNodeStats(graph);
        EdgeStats edgeStats = EdgeStats.constructEdgeStats(graph);
        WeakComponentClusteringThread weakComponents = new WeakComponentClusteringThread(graph);
        StrongComponentClusteringThread strongComponents = new StrongComponentClusteringThread(graph);
        nodeStats.run();
        edgeStats.run();
        weakComponents.run();
        if (isDirectedGraph) {
            strongComponents.run();
        }
        try {
            nodeStats.join();
            edgeStats.join();
            weakComponents.join();
            strongComponents.join();
            output = NetworkProperties.directedInfo(output, isDirectedGraph);
            output = NetworkProperties.outputNodeAndEdgeStats(output, nodeStats, edgeStats);
            output = NetworkProperties.averageDegreeInfo(output, nodeStats, isDirectedGraph);
            output = NetworkProperties.weakConnectedInfo(output, weakComponents, nodeStats);
            if (isDirectedGraph) {
                output = NetworkProperties.strongConnectedInfo(output, strongComponents);
            } else {
                output.append("Did not calculate strong connectedness because this graph was not directed.");
                output.append(LINE_SEP);
            }
            output = edgeStats.getNumberOfParallelEdges() <= 0 && edgeStats.getNumberOfSelfLoops() <= 0 ? NetworkProperties.densityInfo(output, edgeStats, graph.getNodeCount(), graph.getEdgeCount(), isDirectedGraph) : NetworkProperties.addWarningMessages(output, edgeStats, isDirectedGraph);
            return output;
        }
        catch (InterruptedException ie) {
            throw new AlgorithmExecutionException("There were errors completing the evaluation. One of the threads has died.", (Throwable)ie);
        }
    }

    private static StringBuffer addWarningMessages(StringBuffer sb, EdgeStats es, boolean isDirected) {
        if (es.getNumberOfSelfLoops() > 0 && es.getNumberOfParallelEdges() > 0) {
            sb.append("Did not calculate density due to the presence of self-loops and parallel edges.");
        }
        if (es.getNumberOfSelfLoops() > 0 && es.getNumberOfParallelEdges() == 0) {
            sb.append("Did not calculate density due to the presence of self-loops.");
        }
        if (es.getNumberOfSelfLoops() == 0 && es.getNumberOfParallelEdges() > 0) {
            sb.append("Did not calculate density due to the presence of parallel edges.");
        }
        sb.append(LINE_SEP);
        if (es.getNumberOfSelfLoops() > 0 && !isDirected) {
            sb.append("This graph claims to be undirected but has self-loops. Please re-examine your data.");
            sb.append(LINE_SEP);
        }
        if (es.getNumberOfParallelEdges() > 0 && !isDirected) {
            sb.append("This graph claims to be undirected but has parallel edges. Please re-examine your data.");
            sb.append(LINE_SEP);
        }
        sb.append("Many algorithms will not function correctly with this graph.");
        sb.append(LINE_SEP);
        return sb;
    }

    private static StringBuffer outputNodeAndEdgeStats(StringBuffer sb, NodeStats ns, EdgeStats es) {
        sb.append(LINE_SEP);
        sb.append(ns.nodeInfo());
        sb.append(LINE_SEP);
        sb.append(es.appendEdgeInfo());
        sb.append(LINE_SEP);
        return sb;
    }

    protected static StringBuffer averageDegreeInfo(StringBuffer sb, NodeStats ns, boolean isDirected) {
        if (isDirected) {
            sb.append("Average total degree: " + ns.getRoundedAverageDegree());
            sb.append(LINE_SEP);
            sb.append("Average in degree: " + ns.getRoundedAverageInDegree());
            sb.append(LINE_SEP);
            sb.append("Average out degree: " + ns.getRoundedAverageOutDegree());
        } else {
            sb.append("Average degree: " + ns.getRoundedAverageDegree());
        }
        sb.append(LINE_SEP);
        return sb;
    }

    protected static StringBuffer directedInfo(StringBuffer sb, boolean isDirected) {
        if (isDirected) {
            sb.append("This graph claims to be directed.");
        } else {
            sb.append("This graph claims to be undirected.");
        }
        sb.append(LINE_SEP);
        return sb;
    }

    protected static StringBuffer weakConnectedInfo(StringBuffer sb, WeakComponentClusteringThread wcct, NodeStats ns) {
        if (wcct.getClusters() == 1) {
            sb.append("This graph is weakly connected.");
            sb.append(LINE_SEP);
        } else {
            sb.append("This graph is not weakly connected.");
            sb.append(LINE_SEP);
        }
        sb.append("There are " + wcct.getClusters() + " weakly connected components. (" + ns.getNumberOfIsolatedNodes() + " isolates)");
        sb.append(LINE_SEP);
        sb.append("The largest connected component consists of " + wcct.getMaxSize() + " nodes.");
        sb.append(LINE_SEP);
        return sb;
    }

    protected static StringBuffer strongConnectedInfo(StringBuffer sb, StrongComponentClusteringThread scct) {
        if (scct.getClusters() == 1) {
            sb.append("This graph is strongly connected");
            sb.append(LINE_SEP);
        } else {
            sb.append("This graph is not strongly connected.");
            sb.append(LINE_SEP);
        }
        sb.append("There are " + scct.getClusters() + " strongly connected components.");
        sb.append(LINE_SEP);
        sb.append("The largest strongly connected component consists of " + scct.getMaxSize() + " nodes.");
        sb.append(LINE_SEP);
        sb.append(LINE_SEP);
        return sb;
    }

    public static StringBuffer densityInfo(StringBuffer sb, EdgeStats es, int numNodes, int numEdges, boolean isDirected) {
        sb.append(LINE_SEP);
        double density = NetworkProperties.calculateDensity(numNodes, numEdges, isDirected);
        String densityString = roundedStatisticsFormatter.format(density);
        sb.append("Density (disregarding weights): " + densityString);
        int numberOfAdditionalNumericAttributes = es.numericAttributes.size();
        if (numberOfAdditionalNumericAttributes > 0) {
            sb.append(LINE_SEP);
            sb.append("Additional Densities by Numeric Attribute");
        }
        sb.append(LINE_SEP);
        sb.append(LINE_SEP);
        return sb;
    }

    private static String printWeightedDensities(boolean useObservedMax, EdgeStats es, int numNodes, boolean isDirected) {
        StringBuffer sb = new StringBuffer();
        long maxConnections = (long)numNodes * ((long)numNodes - 1L);
        if (useObservedMax) {
            sb.append("densities (weighted against observed max)");
        } else {
            sb.append("densities (weighted against standard max)");
        }
        sb.append(LINE_SEP);
        int i = 0;
        while (i < es.getAdditionalNumericAttributes().length) {
            sb.append(String.valueOf(es.getAdditionalNumericAttributes()[i]) + ": ");
            double weightedSum = es.getWeightedDensitySumArray()[i];
            double maxObservedValue = es.getMaxValueArray()[i];
            double weightedDensity = isDirected ? weightedSum / (double)maxConnections : weightedSum / (0.5 * (double)maxConnections);
            if (useObservedMax) {
                weightedDensity /= maxObservedValue;
            }
            sb.append(roundedStatisticsFormatter.format(weightedDensity));
            sb.append(LINE_SEP);
            ++i;
        }
        return sb.toString();
    }

    protected static double calculateDensity(int numberOfNodes, int numberOfEdges, boolean isDirected) {
        long maxEdges = (long)numberOfNodes * (long)(numberOfNodes - 1);
        if (isDirected) {
            return (double)numberOfEdges / (double)maxEdges;
        }
        return (double)numberOfEdges / (double)(maxEdges / 2L);
    }

    protected static double calculateAverageDegree(int numNodes, int numEdges) {
        double averageDegree = 2.0 * (double)numEdges / (double)numNodes;
        return averageDegree;
    }
}

