/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.toolkit.networkanalysis.analysis;

import edu.iu.nwb.toolkit.networkanalysis.analysis.NetworkProperties;
import java.util.Iterator;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;

public class NodeStats
extends Thread {
    int numberOfNodes;
    int numberOfAttributes;
    String[] nodeAttributes;
    double averageDegree = 0.0;
    double averageInDegree = 0.0;
    double averageOutDegree = 0.0;
    int numberOfIsolatedNodes = 0;
    private Graph nodeGraph;

    private NodeStats(Graph graph) {
        this.nodeGraph = graph;
    }

    public static NodeStats constructNodeStats(Graph graph) {
        return new NodeStats(graph);
    }

    private void findIsolatedNodes(Graph graph) {
        Iterator it = graph.nodes();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            int degree = n.getDegree();
            if (degree == 0) {
                ++this.numberOfIsolatedNodes;
            }
            this.averageDegree += (double)degree / (double)this.numberOfNodes;
            if (!graph.isDirected()) continue;
            this.averageInDegree += (double)n.getInDegree() / (double)this.numberOfNodes;
            this.averageOutDegree += (double)n.getOutDegree() / (double)this.numberOfNodes;
        }
    }

    private void initializeAttributes(Graph graph) {
        Table t = graph.getNodeTable();
        this.numberOfAttributes = t.getColumnCount();
        this.nodeAttributes = new String[this.numberOfAttributes];
        int i = 0;
        while (i < this.numberOfAttributes) {
            this.nodeAttributes[i] = t.getColumnName(i);
            ++i;
        }
    }

    @Override
    public void run() {
        this.numberOfNodes = this.nodeGraph.getNodeCount();
        this.initializeAttributes(this.nodeGraph);
        this.numberOfIsolatedNodes = 0;
        this.findIsolatedNodes(this.nodeGraph);
    }

    public int getNumberOfIsolatedNodes() {
        return this.numberOfIsolatedNodes;
    }

    public String printNumberOfIsolatedNodes() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.numberOfIsolatedNodes);
        return sb.toString();
    }

    public boolean hasIsolatedNodes() {
        return this.numberOfIsolatedNodes > 0;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public String[] getNodeAttributes() {
        return this.nodeAttributes;
    }

    public double getRoundedAverageDegree() {
        return Double.parseDouble(NetworkProperties.roundedStatisticsFormatter.format(this.averageDegree));
    }

    public double getRoundedAverageInDegree() {
        return Double.parseDouble(NetworkProperties.roundedStatisticsFormatter.format(this.averageInDegree));
    }

    public double getRoundedAverageOutDegree() {
        return Double.parseDouble(NetworkProperties.roundedStatisticsFormatter.format(this.averageOutDegree));
    }

    protected String nodeInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Nodes: " + this.numberOfNodes);
        sb.append(System.getProperty("line.separator"));
        sb.append(this.isolatedNodeInfo());
        sb.append(System.getProperty("line.separator"));
        sb.append("Node attributes present: ");
        int numAttributes = this.numberOfAttributes;
        int i = 0;
        while (i < numAttributes) {
            sb.append(this.nodeAttributes[i]);
            if (i != numAttributes - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    protected String isolatedNodeInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Isolated nodes: " + this.numberOfIsolatedNodes);
        return sb.toString();
    }
}

