/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.toolkit.networkanalysis.analysis;

import edu.iu.nwb.toolkit.networkanalysis.analysis.SimpleEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;

public class SelfLoopsParallelEdges {
    int numberOfSelfLoops = 0;
    int numberOfParallelEdges = 0;
    boolean directed = false;
    String selfLoopInfo;
    String parallelEdgeInfo;

    public SelfLoopsParallelEdges(Graph g) {
        Edge edg;
        HashSet selfLoops = new HashSet();
        HashSet parallelEdges = new HashSet();
        HashMap edges = new HashMap();
        boolean directed = g.isDirected();
        Iterator it = g.edges();
        while (it.hasNext()) {
            edg = (Edge)it.next();
            this.addEdge(edg, directed, selfLoops, parallelEdges, edges);
        }
        this.selfLoopInfo = this.calculateSelfLoops(selfLoops);
        this.parallelEdgeInfo = this.calculateParallelEdges(parallelEdges, edges);
        selfLoops = null;
        edges = null;
        parallelEdges = null;
        edg = null;
    }

    public void addEdge(Edge e, boolean isDirected, HashSet selfLoops, HashSet parallelEdges, HashMap edges) {
        SimpleEdge se = new SimpleEdge(e);
        if (isDirected) {
            if (edges.get(se) == null) {
                HashSet<Edge> temp = new HashSet<Edge>();
                temp.add(e);
                edges.put(se, temp);
            } else if (((HashSet)edges.get(se)).add(e)) {
                parallelEdges.add(se);
                ++this.numberOfParallelEdges;
            }
        } else {
            SimpleEdge se2 = new SimpleEdge(e.getTargetNode().getRow(), e.getSourceNode().getRow());
            if (edges.get(se) == null && edges.get(se2) == null) {
                HashSet<Edge> temp = new HashSet<Edge>();
                temp.add(e);
                edges.put(se, temp);
            } else if (edges.get(se) != null) {
                if (((HashSet)edges.get(se)).add(e)) {
                    parallelEdges.add(se);
                    ++this.numberOfParallelEdges;
                }
            } else if (((HashSet)edges.get(se2)).add(e)) {
                ++this.numberOfParallelEdges;
                parallelEdges.add(se2);
            }
        }
        if (e.getSourceNode().getRow() == e.getTargetNode().getRow()) {
            selfLoops.add(e);
            ++this.numberOfSelfLoops;
        }
    }

    public int getNumSelfLoops() {
        return this.numberOfSelfLoops;
    }

    public int getNumParallelEdges() {
        return this.numberOfParallelEdges;
    }

    private String calculateParallelEdges(HashSet parallelEdges, HashMap edges) {
        StringBuffer sb = new StringBuffer();
        for (SimpleEdge se : parallelEdges) {
            sb.append("There are " + ((HashSet)edges.get(se)).size() + " edges between node: \n\t");
            Iterator it2 = ((HashSet)edges.get(se)).iterator();
            Edge edg = (Edge)it2.next();
            Node nd = edg.getSourceNode();
            int columns = nd.getColumnCount();
            int i = 0;
            while (i < columns) {
                sb.append(nd.get(i) + " ");
                ++i;
            }
            sb.append(System.getProperty("line.separator"));
            sb.append("and node: \n\t");
            nd = edg.getTargetNode();
            columns = nd.getColumnCount();
            i = 0;
            while (i < columns) {
                sb.append(nd.get(i) + " ");
                ++i;
            }
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private String calculateSelfLoops(HashSet selfLoops) {
        StringBuffer sb = new StringBuffer();
        for (Edge edg : selfLoops) {
            Node nd = edg.getSourceNode();
            sb.append("The node: \n\t");
            int i = 0;
            while (i < nd.getColumnCount()) {
                sb.append(nd.get(i) + " ");
                ++i;
            }
            sb.append("\nhas an edge with itself.");
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String printSelfLoops() {
        return this.selfLoopInfo;
    }

    public String printParallelEdges() {
        return this.parallelEdgeInfo;
    }
}

