/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.toolkit.networkanalysis.analysis;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import prefuse.data.CascadedTable;
import prefuse.data.Graph;
import prefuse.data.Node;

public class StrongComponentClusteringThread
extends Thread {
    private static String preOrderColumn = "preOrder";
    private static String strongComponentColumn = "strongComponentID";
    private Graph clusterGraph;
    private int clusters = 0;
    private int maxSize = 0;

    public StrongComponentClusteringThread(Graph g) {
        this.clusterGraph = g;
    }

    @Override
    public void run() {
        this.strongComponentCalculation();
    }

    private void strongComponentCalculation() {
        int nodeCount = this.clusterGraph.getNodeCount();
        Stack firstStack = new Stack();
        firstStack.setSize(nodeCount);
        Stack secondStack = new Stack();
        secondStack.setSize(nodeCount);
        this.clusters = 0;
        Integer testCount = new Integer(0);
        int[] id = new int[nodeCount];
        int[] pre = new int[nodeCount];
        Arrays.fill(id, -1);
        Arrays.fill(pre, -1);
        CascadedTable statTable = new CascadedTable(this.clusterGraph.getNodeTable());
        statTable.addColumn(preOrderColumn, Integer.TYPE, (Object)new Integer(-1));
        statTable.addColumn(strongComponentColumn, Integer.TYPE, (Object)new Integer(-1));
        Iterator it = this.clusterGraph.nodes();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (statTable.getInt(n.getRow(), preOrderColumn) != -1) continue;
            this.recursiveStrongComponentCalculation(this.clusterGraph, n, statTable, firstStack, secondStack, testCount);
        }
    }

    private void recursiveStrongComponentCalculation(Graph g, Node n, CascadedTable ct, Stack firstStack, Stack secondStack, Integer count) {
        int v;
        count = new Integer(count + 1);
        ct.setInt(n.getRow(), preOrderColumn, count.intValue());
        firstStack.push(new Integer(n.getRow()));
        secondStack.push(new Integer(n.getRow()));
        Iterator it = n.outNeighbors();
        while (it.hasNext()) {
            int outNode = ((Node)it.next()).getRow();
            if (ct.getInt(outNode, preOrderColumn) == -1) {
                this.recursiveStrongComponentCalculation(g, g.getNode(outNode), ct, firstStack, secondStack, count);
                continue;
            }
            if (ct.getInt(outNode, strongComponentColumn) != -1) continue;
            while (ct.getInt(((Integer)secondStack.peek()).intValue(), preOrderColumn) > ct.getInt(outNode, preOrderColumn)) {
                secondStack.pop();
            }
        }
        if (((Integer)secondStack.peek()).intValue() != n.getRow()) {
            return;
        }
        secondStack.pop();
        int size = 0;
        do {
            ++size;
            v = (Integer)firstStack.pop();
            ct.setInt(v, strongComponentColumn, this.clusters);
        } while (n.getRow() != v);
        if (size > this.maxSize) {
            this.maxSize = size;
        }
        ++this.clusters;
    }

    public int getClusters() {
        return this.clusters;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

