/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile;

import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NWBFileParser {
    private BufferedReader fileReader;
    private NWBFileParserHandler handler;
    private boolean hasHeader_Nodes = false;
    private boolean hasHeader_UndirectedEdges = false;
    private boolean hasHeader_DirectedEdges = false;
    private boolean isFileGood = true;
    private boolean inNodesSection = false;
    private boolean inUndirectededgesSection = false;
    private boolean inDirectededgesSection = false;
    private boolean hasTotalNumOfNodes = false;
    private boolean passHeader = false;
    private int totalNumOfNodes;
    private int currentLine;
    private int countedNumDirected;
    private int countedNumUndirected;
    private int countedNodes;
    private StringBuffer errorMessages = new StringBuffer();
    private Collection<NWBAttribute> nodeAttributes;
    private Collection<NWBAttribute> directedEdgeAttributes;
    private Collection<NWBAttribute> undirectedEdgeAttributes;

    public NWBFileParser(String file) throws IOException {
        this(new File(file));
    }

    public NWBFileParser(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public NWBFileParser(InputStream input) throws IOException {
        this(new InputStreamReader(input, "UTF-8"));
    }

    public NWBFileParser(Reader input) {
        this.fileReader = new BufferedReader(input);
    }

    public void parse(NWBFileParserHandler handler) throws ParsingException, IOException {
        this.handler = handler;
        try {
            try {
                this.processFile(this.fileReader);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParsingException(e);
            }
        }
        finally {
            handler.finishedParsing();
        }
        if (this.errorMessages.length() > 0) {
            throw new ParsingException(this.errorMessages.toString());
        }
    }

    private void processFile(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && this.isFileGood && !this.handler.haltParsingNow()) {
            ++this.currentLine;
            if ((line = line.trim()).startsWith("#")) {
                this.handler.addComment(line.substring(1));
            } else if (!(line.length() == 0 || this.validateNodeHeader(line) || this.validateDirectedEdgeHeader(line) || this.validateUndirectedEdgeHeader(line))) {
                if (this.inNodesSection && this.isFileGood) {
                    this.processNodeLine(line);
                } else if (this.inDirectededgesSection && this.isFileGood) {
                    this.processDirectedEdgeLine(line);
                } else if (this.inUndirectededgesSection && this.isFileGood) {
                    this.processUndirectedEdgeLine(line);
                }
            }
            line = reader.readLine();
        }
        if (this.handler.haltParsingNow()) {
            this.errorMessages = new StringBuffer();
        } else {
            if (this.isFileGood) {
                this.checkFile();
            }
            if (this.hasTotalNumOfNodes && this.countedNodes != this.totalNumOfNodes) {
                this.isFileGood = false;
                this.errorMessages.append("There was an inconsistency between the specified number of nodes: " + this.totalNumOfNodes + " and the " + "number of nodes counted: " + this.countedNodes);
            }
            this.totalNumOfNodes = this.countedNodes;
        }
        this.fileReader.close();
    }

    private void checkFile() {
        if (!this.hasHeader_Nodes) {
            this.isFileGood = false;
            this.errorMessages.append("*The file does not specify the node header.\n\n");
        } else if (!this.hasHeader_DirectedEdges && !this.hasHeader_UndirectedEdges) {
            this.isFileGood = false;
            this.errorMessages.append("This file has not specified a valid edge header.");
        }
    }

    private boolean validateNodeHeader(String header) {
        if (header.startsWith("*Nodes")) {
            this.hasHeader_Nodes = true;
            this.inNodesSection = true;
            this.inDirectededgesSection = false;
            this.inUndirectededgesSection = false;
            this.passHeader = true;
            this.nodeAttributes = new ArrayList<NWBAttribute>();
            StringTokenizer stringTokenizer = new StringTokenizer(header);
            if (stringTokenizer.countTokens() > 1) {
                stringTokenizer.nextToken();
                this.totalNumOfNodes = new Integer(stringTokenizer.nextToken());
                this.hasTotalNumOfNodes = true;
                this.handler.setNodeCount(this.totalNumOfNodes);
            } else {
                this.hasTotalNumOfNodes = false;
            }
            return true;
        }
        if (header.equalsIgnoreCase("*Nodes")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the node section fileReader an nwb file should be *Nodes and it is case sensitive. The current header is " + header + ".\n\n");
            return false;
        }
        return false;
    }

    private boolean validateDirectedEdgeHeader(String header) {
        if (header.startsWith("*DirectedEdges")) {
            this.hasHeader_DirectedEdges = true;
            this.inDirectededgesSection = true;
            this.inNodesSection = false;
            this.inUndirectededgesSection = false;
            this.passHeader = true;
            this.directedEdgeAttributes = new ArrayList<NWBAttribute>();
            StringTokenizer tokenizer = new StringTokenizer(header);
            if (tokenizer.countTokens() > 1) {
                tokenizer.nextToken();
                int totalEdges = new Integer(tokenizer.nextToken());
                this.handler.setDirectedEdgeCount(totalEdges);
            }
            return true;
        }
        if (header.equalsIgnoreCase("*DirectedEdges")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the directed edge section should be *DirectedEdges and it is case sensitive. The current header is " + header + ".\n\n");
            return false;
        }
        return false;
    }

    private boolean validateUndirectedEdgeHeader(String header) {
        if (header.startsWith("*UndirectedEdges")) {
            this.hasHeader_UndirectedEdges = true;
            this.inUndirectededgesSection = true;
            this.inNodesSection = false;
            this.inDirectededgesSection = false;
            this.passHeader = true;
            this.undirectedEdgeAttributes = new ArrayList<NWBAttribute>();
            StringTokenizer tokenizer = new StringTokenizer(header);
            if (tokenizer.countTokens() > 1) {
                tokenizer.nextToken();
                int totalEdges = new Integer(tokenizer.nextToken());
                this.handler.setUndirectedEdgeCount(totalEdges);
            }
            return true;
        }
        if (header.equalsIgnoreCase("*UndirectedEdges")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the undirected edge section should be *UndirectedEdges and it is case sensitive. The current header is " + header + ".\n\n");
            return false;
        }
        return false;
    }

    private void processNodeLine(String rawNodeLine) {
        if (this.passHeader) {
            if (rawNodeLine.startsWith("id")) {
                StringTokenizer st = new StringTokenizer(rawNodeLine);
                int totalTokens = st.countTokens();
                int i = 1;
                while (i <= totalTokens) {
                    try {
                        NWBAttribute attribute = NWBFileParser.processAttributeToken(st.nextToken());
                        this.nodeAttributes.add(attribute);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++i;
                }
                if (this.isFileGood) {
                    LinkedHashMap<String, String> nodeSchema = new LinkedHashMap<String, String>();
                    for (NWBAttribute attribute : this.nodeAttributes) {
                        nodeSchema.put(attribute.getAttrName(), attribute.getDataType());
                    }
                    this.handler.setNodeSchema(nodeSchema);
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ". The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                Map<String, Object> attributes = NWBFileParser.validateALine(rawNodeLine, this.nodeAttributes);
                int id = (Integer)attributes.remove("id");
                String label = (String)attributes.remove("label");
                this.handler.addNode(id, label, attributes);
                ++this.countedNodes;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private void processDirectedEdgeLine(String rawLineEdge) {
        if (this.passHeader) {
            if (rawLineEdge.startsWith("source")) {
                StringTokenizer tokenizer = new StringTokenizer(rawLineEdge);
                int tokens = tokenizer.countTokens();
                int ii = 1;
                while (ii <= tokens) {
                    String token = tokenizer.nextToken();
                    try {
                        NWBAttribute attribute = NWBFileParser.processAttributeToken(token);
                        this.directedEdgeAttributes.add(attribute);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++ii;
                }
                if (this.isFileGood) {
                    LinkedHashMap<String, String> edgeSchema = new LinkedHashMap<String, String>();
                    for (NWBAttribute attribute : this.directedEdgeAttributes) {
                        edgeSchema.put(attribute.getAttrName(), attribute.getDataType());
                    }
                    this.handler.setDirectedEdgeSchema(edgeSchema);
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + "The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                Map<String, Object> attributes = NWBFileParser.validateALine(rawLineEdge, this.directedEdgeAttributes);
                int source = (Integer)attributes.remove("source");
                int target = (Integer)attributes.remove("target");
                this.handler.addDirectedEdge(source, target, attributes);
                ++this.countedNumDirected;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private void processUndirectedEdgeLine(String rawEdgeLine) {
        if (this.passHeader) {
            if (rawEdgeLine.startsWith("source")) {
                StringTokenizer tokenizer = new StringTokenizer(rawEdgeLine);
                int tokens = tokenizer.countTokens();
                int ii = 1;
                while (ii <= tokens) {
                    try {
                        String token = tokenizer.nextToken();
                        NWBAttribute attribute = NWBFileParser.processAttributeToken(token);
                        this.undirectedEdgeAttributes.add(attribute);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++ii;
                }
                if (this.isFileGood) {
                    LinkedHashMap<String, String> edgeSchema = new LinkedHashMap<String, String>();
                    for (NWBAttribute attribute : this.undirectedEdgeAttributes) {
                        edgeSchema.put(attribute.getAttrName(), attribute.getDataType());
                    }
                    this.handler.setUndirectedEdgeSchema(edgeSchema);
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + "The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                Map<String, Object> attributes = NWBFileParser.validateALine(rawEdgeLine, this.undirectedEdgeAttributes);
                int source = (Integer)attributes.remove("source");
                int target = (Integer)attributes.remove("target");
                this.handler.addUndirectedEdge(source, target, attributes);
                ++this.countedNumUndirected;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private static Map<String, Object> validateALine(String line, Collection<NWBAttribute> attributes) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(line);
        int totalTokens = stringTokenizer.countTokens();
        if (totalTokens < attributes.size()) {
            throw new Exception("Did not specify all values for defined attributes!");
        }
        HashMap<String, Object> entity = new HashMap<String, Object>();
        String[] columns = NWBFileParser.processTokens(stringTokenizer);
        int columnIndex = -1;
        for (NWBAttribute nwbAttribute : attributes) {
            String dataType = nwbAttribute.getDataType();
            if (columns[++columnIndex].equalsIgnoreCase("*")) continue;
            if (dataType.equalsIgnoreCase("string")) {
                NWBFileParser.validateIsAString(columns[columnIndex]);
                columns[columnIndex] = columns[columnIndex].replace('\"', ' ').trim();
                entity.put(nwbAttribute.getAttrName(), columns[columnIndex]);
                continue;
            }
            if (dataType.equalsIgnoreCase("int")) {
                NWBFileParser.validateIsAnIntegerOrID(columns[columnIndex], nwbAttribute.getAttrName());
                entity.put(nwbAttribute.getAttrName(), new Integer(columns[columnIndex]));
                continue;
            }
            if (!dataType.equalsIgnoreCase("float") && !dataType.equalsIgnoreCase("real")) continue;
            NWBFileParser.validateIsAFloat(columns[columnIndex]);
            entity.put(nwbAttribute.getAttrName(), new Float(columns[columnIndex]));
        }
        return entity;
    }

    private static boolean validateIsAnIntegerOrID(String input, String attribute) throws NumberFormatException, Exception {
        Integer value = new Integer(input);
        if ((attribute.equalsIgnoreCase("id") || attribute.equalsIgnoreCase("source") || attribute.equalsIgnoreCase("target")) && value < 1) {
            throw new Exception("The node id must be greater than 0.");
        }
        return true;
    }

    private static boolean validateIsAString(String input) throws Exception {
        if (!input.startsWith("\"") || !input.endsWith("\"")) {
            throw new Exception("A string value must be surrounded by double quotation marks.");
        }
        return true;
    }

    private static boolean validateIsAFloat(String input) throws NumberFormatException, Exception {
        Float floatValue = new Float(input);
        floatValue.floatValue();
        return true;
    }

    private static NWBAttribute processAttributeToken(String token) throws Exception {
        if (token.indexOf("*") != -1) {
            String attr_type;
            String attr_name = token.substring(0, token.indexOf("*"));
            if (attr_name.startsWith("//")) {
                attr_name = attr_name.substring(2);
            }
            if (!((attr_type = token.substring(token.indexOf("*") + 1)).equalsIgnoreCase("float") || attr_type.equalsIgnoreCase("real") || attr_type.equalsIgnoreCase("int") || attr_type.equalsIgnoreCase("string"))) {
                throw new Exception("The data type of the attribute " + attr_name + " is not acceptable. Only float, int and string are valid data types fileReader the NWB format.\n" + "You supplied an attribute of " + attr_type);
            }
            return new NWBAttribute(attr_name, attr_type);
        }
        throw new Exception("Can not find * from attribut*datatype line.");
    }

    private static String[] processTokens(StringTokenizer st) {
        int total = st.countTokens();
        int tokenIndex = 0;
        String[] tokens = new String[total];
        StringBuffer bf = new StringBuffer();
        boolean append = false;
        int index = 0;
        while (index < total) {
            String element = st.nextToken();
            if (!append) {
                if (!element.startsWith("\"")) {
                    tokens[tokenIndex] = element;
                    ++tokenIndex;
                } else if (element.startsWith("\"") && element.endsWith("\"") && !element.equals("\"")) {
                    tokens[tokenIndex] = element;
                    ++tokenIndex;
                } else {
                    append = true;
                    bf.append(element);
                }
            } else if (element.endsWith("\\\"") || !element.endsWith("\"")) {
                bf.append(" " + element);
            } else if (element.endsWith("\"")) {
                bf.append(" " + element);
                tokens[tokenIndex] = bf.toString();
                ++tokenIndex;
                bf = new StringBuffer();
                append = false;
            }
            ++index;
        }
        return tokens;
    }

    private static class NWBAttribute {
        private String attributeName;
        private String dataType;

        public NWBAttribute(String name, String type) {
            this.attributeName = name;
            this.dataType = type;
        }

        public String getAttrName() {
            return this.attributeName;
        }

        public String getDataType() {
            return this.dataType;
        }
    }
}

