/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.iu.nwb.util.nwbfile.GetMetadataAndCounts;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import edu.iu.nwb.util.nwbfile.NWBMetadataParsingException;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cishell.utilities.FileUtilities;

public class NWBFileUtilities {
    public static final Collection<String> DEFAULT_NUMBER_KEY_TYPES = Collections.unmodifiableList(Arrays.asList("int", "float"));
    public static final Collection<String> DEFAULT_NUMBER_KEYS_TO_SKIP = Collections.unmodifiableList(Arrays.asList("source", "target"));

    public static void parseNWBFileWithHandler(File nwbFile, NWBFileParserHandler handler) throws ParsingException {
        try {
            NWBFileParser nwbParser = new NWBFileParser(nwbFile);
            nwbParser.parse(handler);
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    public static GetMetadataAndCounts parseMetadata(File nwbFile) throws NWBMetadataParsingException {
        GetMetadataAndCounts nwbFileMetaDataGetter = new GetMetadataAndCounts();
        try {
            NWBFileUtilities.parseNWBFileWithHandler(nwbFile, nwbFileMetaDataGetter);
        }
        catch (ParsingException parsingException) {
            throw new NWBMetadataParsingException(parsingException);
        }
        return nwbFileMetaDataGetter;
    }

    public static LinkedHashMap<String, String> getEdgeSchemaFromMetadata(GetNWBFileMetadata nwbFileMetaDataGetter) {
        LinkedHashMap<String, String> directedEdgeSchema = nwbFileMetaDataGetter.getDirectedEdgeSchema();
        LinkedHashMap<String, String> undirectedEdgeSchema = nwbFileMetaDataGetter.getUndirectedEdgeSchema();
        if (directedEdgeSchema == null) {
            if (undirectedEdgeSchema == null) {
                return new LinkedHashMap<String, String>();
            }
            return undirectedEdgeSchema;
        }
        if (undirectedEdgeSchema == null) {
            return directedEdgeSchema;
        }
        throw new IllegalArgumentException("Hybrid un/directed graph, don't know what to do");
    }

    public static Map<String, String> removeRequiredEdgeProps(Map<String, String> properties) {
        return Maps.difference(properties, NWBFileProperty.NECESSARY_EDGE_ATTRIBUTES).entriesOnlyOnLeft();
    }

    public static Map<String, String> removeRequiredNodeProps(Map<String, String> properties) {
        return Maps.difference(properties, NWBFileProperty.NECESSARY_NODE_ATTRIBUTES).entriesOnlyOnLeft();
    }

    public static Map<String, String> getConsistentEdgeAttributes(GetNWBFileMetadata handler) {
        LinkedHashMap<String, String> directedEdgeSchema = handler.getDirectedEdgeSchema();
        LinkedHashMap<String, String> undirectedEdgeSchema = handler.getUndirectedEdgeSchema();
        if (directedEdgeSchema == null) {
            if (undirectedEdgeSchema == null) {
                return new TreeMap<String, String>();
            }
            return undirectedEdgeSchema;
        }
        if (undirectedEdgeSchema == null) {
            return directedEdgeSchema;
        }
        TreeSet columnsInBoth = new TreeSet(Sets.intersection(directedEdgeSchema.keySet(), undirectedEdgeSchema.keySet()));
        TreeMap schemaOut = Maps.newTreeMap();
        for (String column : columnsInBoth) {
            if (!((String)directedEdgeSchema.get(column)).equals(undirectedEdgeSchema.get(column))) continue;
            schemaOut.put(column, (String)directedEdgeSchema.get(column));
        }
        return schemaOut;
    }

    public static List<String> findNumericAttributes(Map<String, String> schema) {
        ArrayList<String> numerics = new ArrayList<String>();
        if (schema == null) {
            return numerics;
        }
        ImmutableSet numericTypes = ImmutableSet.copyOf(NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES);
        for (Map.Entry<String, String> column : schema.entrySet()) {
            if (!numericTypes.contains((Object)column.getValue())) continue;
            numerics.add(column.getKey());
        }
        return numerics;
    }

    public static LinkedHashMap<String, String> getEdgeMetadata(File nwbFile) throws NWBMetadataParsingException {
        GetMetadataAndCounts nwbFileMetaDataGetter = NWBFileUtilities.parseMetadata(nwbFile);
        return NWBFileUtilities.getEdgeSchemaFromMetadata(nwbFileMetaDataGetter);
    }

    public static LinkedHashMap<String, String> getNodeSchema(File nwbFile) throws NWBMetadataParsingException {
        GetMetadataAndCounts nwbFileMetaDataGetter = NWBFileUtilities.parseMetadata(nwbFile);
        return nwbFileMetaDataGetter.getNodeSchema();
    }

    public static File createTemporaryNWBFile() throws IOException {
        File temporaryNWBFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"NWB-", (String)"nwb");
        return temporaryNWBFile;
    }
}

