/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile;

import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class NWBFileWriter
implements NWBFileParserHandler {
    private PrintStream out;
    LinkedHashMap<String, String> nodeSchema;
    LinkedHashMap<String, String> directedEdgeSchema;
    LinkedHashMap<String, String> undirectedEdgeSchema;
    int nodeCount = -1;
    int directedEdgeCount = -1;
    int undirectedEdgeCount = -1;

    public NWBFileWriter(String file) throws IOException {
        this(new File(file));
    }

    public NWBFileWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public NWBFileWriter(OutputStream output) throws IOException {
        this.out = new PrintStream(output, true, "UTF-8");
    }

    @Override
    public void addComment(String comment) {
        this.out.println("#" + comment);
    }

    @Override
    public void finishedParsing() {
        this.out.close();
    }

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        Iterator<String> keys = this.nodeSchema.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = key.equals("id") ? "" + id : (key.equals("label") ? "\t\"" + label + "\"" : (attributes.containsKey(key) ? (this.nodeSchema.get(key).equals("string") ? "\t\"" + attributes.get(key) + "\"" : "\t" + attributes.get(key)) : "\t*"));
            this.out.print(value);
            if (keys.hasNext()) continue;
            this.out.println();
        }
    }

    @Override
    public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        if (this.directedEdgeSchema == null) {
            throw new RuntimeException("Edge creation before directed edge schema set.");
        }
        this.printEdge(sourceNode, targetNode, attributes, this.directedEdgeSchema);
    }

    @Override
    public void addUndirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        if (this.undirectedEdgeSchema == null) {
            throw new RuntimeException("Edge creation before undirected edge schema set.");
        }
        this.printEdge(sourceNode, targetNode, attributes, this.undirectedEdgeSchema);
    }

    private void printEdge(int sourceNode, int targetNode, Map<String, Object> attributes, LinkedHashMap<String, String> schema) {
        Iterator<String> keys = schema.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = key.equals("source") ? "" + sourceNode : (key.equals("target") ? "\t" + targetNode : (attributes.containsKey(key) ? (schema.get(key).equals("string") ? "\t\"" + attributes.get(key) + "\"" : "\t" + attributes.get(key)) : "\t*"));
            this.out.print(value);
            if (keys.hasNext()) continue;
            this.out.println();
        }
    }

    @Override
    public void setNodeCount(int numberOfNodes) {
        this.nodeCount = numberOfNodes;
    }

    @Override
    public void setDirectedEdgeCount(int numberOfEdges) {
        this.directedEdgeCount = numberOfEdges;
    }

    @Override
    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.undirectedEdgeCount = numberOfEdges;
    }

    @Override
    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        this.nodeSchema = schema;
        this.out.print("*Nodes");
        if (this.nodeCount >= 0) {
            this.out.println(" " + this.nodeCount);
        } else {
            this.out.println();
        }
        Iterator<String> keys = schema.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            this.out.print(String.valueOf(key) + "*" + schema.get(key));
            if (keys.hasNext()) {
                this.out.print("\t");
                continue;
            }
            this.out.println();
        }
    }

    @Override
    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.directedEdgeSchema = schema;
        this.out.print("*DirectedEdges");
        if (this.directedEdgeCount >= 0) {
            this.out.println(" " + this.directedEdgeCount);
        } else {
            this.out.println();
        }
        Iterator<String> keys = schema.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            this.out.print(String.valueOf(key) + "*" + schema.get(key));
            if (keys.hasNext()) {
                this.out.print("\t");
                continue;
            }
            this.out.println();
        }
    }

    public static LinkedHashMap<String, String> getDefaultNodeSchema() {
        LinkedHashMap<String, String> defaultNodeSchema = new LinkedHashMap<String, String>();
        defaultNodeSchema.put("id", "int");
        defaultNodeSchema.put("label", "string");
        return defaultNodeSchema;
    }

    public static LinkedHashMap<String, String> getDefaultEdgeSchema() {
        LinkedHashMap<String, String> defaultEdgeSchema = new LinkedHashMap<String, String>();
        defaultEdgeSchema.put("source", "int");
        defaultEdgeSchema.put("target", "int");
        return defaultEdgeSchema;
    }

    @Override
    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.undirectedEdgeSchema = schema;
        this.out.print("*UndirectedEdges");
        if (this.undirectedEdgeCount >= 0) {
            this.out.println(" " + this.undirectedEdgeCount);
        } else {
            this.out.println();
        }
        Iterator<String> keys = schema.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            this.out.print(String.valueOf(key) + "*" + schema.get(key));
            if (keys.hasNext()) {
                this.out.print("\t");
                continue;
            }
            this.out.println();
        }
    }

    @Override
    public boolean haltParsingNow() {
        return false;
    }
}

