/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.FieldMakerFunction;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeAdder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class NodeAttributeComputer
extends NodeAttributeAdder {
    protected final Map<String, String> schemaUpdates;
    protected final FieldMakerFunction computer;

    NodeAttributeComputer(NWBFileParserHandler delegate, Map<String, String> schemaUpdates, FieldMakerFunction computer) {
        super(delegate, schemaUpdates);
        this.schemaUpdates = schemaUpdates;
        this.computer = computer;
    }

    abstract Map<String, Object> update(Map<String, Object> var1);

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        super.addNode(id, label, this.update(Maps.newHashMap(attributes)));
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("schemaUpdates", this.schemaUpdates).add("computer", (Object)this.computer).add("next", (Object)this.nextToString()).toString();
    }

    static final class AdditiveNodeAttributeComputer
    extends NodeAttributeComputer {
        public AdditiveNodeAttributeComputer(NWBFileParserHandler delegate, Map<String, String> schemaUpdates, FieldMakerFunction computer) {
            super(delegate, schemaUpdates, computer);
        }

        @Override
        public void setNodeSchema(LinkedHashMap<String, String> schema) {
            Preconditions.checkArgument((boolean)AdditiveNodeAttributeComputer.keysDistinct(this.schemaUpdates, schema), (String)"The new attribute names declared (%s) must not collide with any existing attribute names in the schema (%s).", (Object[])new Object[]{Joiner.on((String)", ").join(this.schemaUpdates.keySet()), Joiner.on((String)", ").join(schema.keySet())});
            super.setNodeSchema(schema);
        }

        @Override
        public Map<String, Object> update(Map<String, Object> original) {
            if (!AdditiveNodeAttributeComputer.keysDistinct(this.schemaUpdates, original)) {
                throw new RuntimeException(String.format("The new attribute names declared (%s) must not collide with any existing attribute names for this node (%s).", Joiner.on((String)", ").join(this.schemaUpdates.keySet()), Joiner.on((String)", ").join(original.keySet())));
            }
            Map<String, Object> computed = this.computer.compute(original);
            if (!this.schemaUpdates.keySet().containsAll(computed.keySet())) {
                throw new RuntimeException(String.format("All new attribute names computed (%s) must be among those declared in the schema updates (%s).", Joiner.on((String)", ").join(computed.keySet()), Joiner.on((String)", ").join(this.schemaUpdates.keySet())));
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)(original.size() + computed.size()));
            result.putAll(original);
            result.putAll(computed);
            return result;
        }

        private static boolean keysDistinct(Map<?, ?> map1, Map<?, ?> map2) {
            Sets.SetView commonKeys = Sets.intersection(map1.keySet(), map2.keySet());
            return commonKeys.isEmpty();
        }
    }
}

