/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.util.LinkedHashMap;
import java.util.Map;

class NodeAttributeRenamer
extends ParserStage {
    private ImmutableMap<String, String> renames;

    public static NodeAttributeRenamer create(NWBFileParserHandler handler, Map<String, String> renames) {
        return new NodeAttributeRenamer(handler, renames);
    }

    private NodeAttributeRenamer(NWBFileParserHandler handler, Map<String, String> renames) {
        super(handler);
        this.renames = ImmutableMap.copyOf(renames);
    }

    @Override
    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        super.setNodeSchema(this.renameKeys(schema));
    }

    private <T> LinkedHashMap<String, T> renameKeys(Map<String, T> toModify) {
        LinkedHashMap modified = Maps.newLinkedHashMap();
        for (Map.Entry<String, T> entry : toModify.entrySet()) {
            String field = entry.getKey();
            if (this.renames.containsKey((Object)field)) {
                modified.put((String)this.renames.get((Object)field), entry.getValue());
                continue;
            }
            modified.put(field, entry.getValue());
        }
        return modified;
    }

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        super.addNode(id, label, this.renameKeys(attributes));
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("renames", this.renames).add("next", (Object)this.nextToString()).toString();
    }
}

