/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.GuardParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class NodeInjector
extends ParserStage {
    private final ImmutableList<AnonymousNode> nodesToAdd;
    private boolean haveInjectedNodes = false;
    private int maxNodeId = 0;

    static NodeInjector create(String label, Map<String, ? extends Object> attributes) {
        return new NodeInjector(GuardParserHandler.getInstance(), (List<AnonymousNode>)ImmutableList.of((Object)new AnonymousNode(label, attributes)));
    }

    NodeInjector(NWBFileParserHandler handler, List<AnonymousNode> nodes) {
        super(handler);
        this.nodesToAdd = ImmutableList.copyOf(nodes);
    }

    @Override
    public void setNodeCount(int numberOfNodes) {
        super.setNodeCount(numberOfNodes + this.nodesToAdd.size());
    }

    @Override
    public void finishedParsing() {
        this.inputNodesHaveEnded();
        super.finishedParsing();
    }

    @Override
    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.inputNodesHaveEnded();
        super.setDirectedEdgeSchema(schema);
    }

    @Override
    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.inputNodesHaveEnded();
        super.setUndirectedEdgeSchema(schema);
    }

    private void inputNodesHaveEnded() {
        if (!this.haveInjectedNodes) {
            this.doNodeInjection();
            this.haveInjectedNodes = true;
        }
    }

    private void doNodeInjection() {
        for (AnonymousNode node : this.nodesToAdd) {
            super.addNode(++this.maxNodeId, node.getLabel(), (Map<String, Object>)node.getAttributes());
        }
    }

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        super.addNode(id, label, attributes);
        if (id > this.maxNodeId) {
            this.maxNodeId = id;
        }
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("to inject", this.nodesToAdd.size()).add("have injected", this.haveInjectedNodes).add("next", (Object)this.nextToString()).toString();
    }

    private static class AnonymousNode {
        private final String label;
        private final ImmutableMap<String, Object> attributes;

        public AnonymousNode(String label, Map<String, ? extends Object> attributes) {
            this.label = label;
            this.attributes = ImmutableMap.copyOf(attributes);
        }

        public String getLabel() {
            return this.label;
        }

        public ImmutableMap<String, Object> getAttributes() {
            return this.attributes;
        }
    }

    public static class Builder {
        private List<AnonymousNode> nodes = Lists.newArrayList();
        private NWBFileParserHandler handler;

        public Builder(NWBFileParserHandler handler) {
            this.handler = handler;
        }

        public Builder withNode(String label) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of()));
            return this;
        }

        public Builder withNode(String label, String k1, Object v1) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of((Object)k1, (Object)v1)));
            return this;
        }

        public Builder withNode(String label, String k1, Object v1, String k2, Object v2) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2)));
            return this;
        }

        public Builder withNode(String label, String k1, Object v1, String k2, Object v2, String k3, Object v3) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3)));
            return this;
        }

        public Builder withNode(String label, String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4)));
            return this;
        }

        public Builder withNode(String label, String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4, (Object)k5, (Object)v5)));
            return this;
        }

        public Builder withNode(String label, Map<String, ? extends Object> attributes) {
            this.nodes.add(new AnonymousNode(label, (Map<String, ? extends Object>)ImmutableMap.copyOf(attributes)));
            return this;
        }

        public ParserStage build() {
            return new NodeInjector(this.handler, this.nodes);
        }
    }
}

