/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Objects;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.model.Edge;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.util.LinkedHashMap;
import java.util.Map;

class OrderedEdgeCollector
extends ParserStage {
    private MinMaxPriorityQueue<Edge> edges;
    private LinkedHashMap<String, String> directedEdgeSchema;
    private LinkedHashMap<String, String> undirectedEdgeSchema;
    private boolean hasDirectedEdges = false;
    private boolean hasUndirectedEdges = false;
    private Ordering<? super Edge> ordering;
    private int edgeLimit;

    public OrderedEdgeCollector(NWBFileParserHandler writer, int edgeLimit, Ordering<? super Edge> ordering) {
        super(writer);
        this.edgeLimit = edgeLimit;
        this.ordering = ordering;
        this.edges = OrderedEdgeCollector.createQueue(edgeLimit, ordering);
    }

    @Override
    public void addDirectedEdge(int source, int target, Map<String, Object> attributes) {
        this.hasDirectedEdges = true;
        this.edges.offer((Object)new Edge(source, target, attributes, true));
    }

    @Override
    public void addUndirectedEdge(int source, int target, Map<String, Object> attributes) {
        this.hasUndirectedEdges = true;
        this.edges.offer((Object)new Edge(source, target, attributes, false));
    }

    private static MinMaxPriorityQueue<Edge> createQueue(int edgeLimit, Ordering<? super Edge> ordering) {
        return MinMaxPriorityQueue.orderedBy(ordering).maximumSize(edgeLimit).create();
    }

    @Override
    public void finishedParsing() {
        if (this.hasDirectedEdges) {
            super.setDirectedEdgeSchema(this.directedEdgeSchema);
            for (Edge e : this.edges) {
                if (!e.isDirected()) continue;
                super.addDirectedEdge(e.getSource(), e.getTarget(), (Map<String, Object>)e.getAttributes());
            }
        }
        if (this.hasUndirectedEdges) {
            super.setUndirectedEdgeSchema(this.undirectedEdgeSchema);
            for (Edge e : this.edges) {
                if (e.isDirected()) continue;
                super.addUndirectedEdge(e.getSource(), e.getTarget(), (Map<String, Object>)e.getAttributes());
            }
        }
        super.finishedParsing();
        this.edges = null;
    }

    @Override
    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    @Override
    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    @Override
    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.directedEdgeSchema = schema;
    }

    @Override
    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.undirectedEdgeSchema = schema;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("limit", this.edgeLimit).add("ordering", this.ordering).add("next", (Object)this.nextToString()).toString();
    }
}

