/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Objects;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.model.Node;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.util.LinkedHashMap;
import java.util.Map;

class OrderedNodeCollector
extends ParserStage {
    private MinMaxPriorityQueue<Node> nodes;
    private boolean nodesWritten;
    private Ordering<? super Node> ordering;
    private int nodeLimit;

    public OrderedNodeCollector(NWBFileParserHandler writer, int nodeLimit, Ordering<? super Node> ordering) {
        super(writer);
        this.nodeLimit = nodeLimit;
        this.ordering = ordering;
        this.createQueue(nodeLimit, ordering);
    }

    private void createQueue(int edgeLimit, Ordering<? super Node> ordering) {
        this.nodes = MinMaxPriorityQueue.orderedBy(ordering).maximumSize(edgeLimit).create();
    }

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        this.nodes.offer((Object)new Node(id, label, attributes));
    }

    @Override
    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.doneWithNodes();
        super.setDirectedEdgeSchema(schema);
    }

    @Override
    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.doneWithNodes();
        super.setUndirectedEdgeSchema(schema);
    }

    private void doneWithNodes() {
        this.writeNodesOnce();
    }

    private void writeNodesOnce() {
        if (!this.nodesWritten) {
            for (Node n : this.nodes) {
                super.addNode(n.getId(), n.getLabel(), (Map<String, Object>)n.getAttributes());
            }
            this.nodesWritten = true;
        }
    }

    @Override
    public void finishedParsing() {
        this.doneWithNodes();
        super.finishedParsing();
        this.nodes = null;
    }

    @Override
    public void setNodeCount(int numberOfNodes) {
        super.setNodeCount(Math.min(numberOfNodes, this.nodeLimit));
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("limit", this.nodeLimit).add("ordering", this.ordering).add("next", (Object)this.nextToString()).toString();
    }
}

