/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import edu.iu.nwb.util.nwbfile.ForwardingNWBHandler;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import edu.iu.nwb.util.nwbfile.model.AttributePredicate;
import edu.iu.nwb.util.nwbfile.model.Edge;
import edu.iu.nwb.util.nwbfile.model.NWBGraphPart;
import edu.iu.nwb.util.nwbfile.model.Node;
import edu.iu.nwb.util.nwbfile.pipe.EdgeFilter;
import edu.iu.nwb.util.nwbfile.pipe.FieldMakerFunction;
import edu.iu.nwb.util.nwbfile.pipe.GuardParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeAdder;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeComputer;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeDefaulter;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeRemover;
import edu.iu.nwb.util.nwbfile.pipe.NodeAttributeRenamer;
import edu.iu.nwb.util.nwbfile.pipe.NodeFilter;
import edu.iu.nwb.util.nwbfile.pipe.NodeInjector;
import edu.iu.nwb.util.nwbfile.pipe.OrderedEdgeCollector;
import edu.iu.nwb.util.nwbfile.pipe.OrderedNodeCollector;
import edu.iu.nwb.util.nwbfile.pipe.OrphanEdgeRemover;
import edu.iu.nwb.util.nwbfile.pipe.ParserStage;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ParserPipe {
    private ParserStage pipeHead = new ParserStage();

    public ParserPipe filterNodes(AttributePredicate filter) {
        this.extendParserPipe(new NodeFilter(GuardParserHandler.getInstance(), filter));
        return this.removeOrphanEdges();
    }

    public ParserPipe removeOrphanEdges() {
        this.extendParserPipe(new OrphanEdgeRemover());
        return this;
    }

    public ParserPipe filterEdges(AttributePredicate filter) {
        this.extendParserPipe(new EdgeFilter(GuardParserHandler.getInstance(), filter));
        return this;
    }

    public ParserPipe addStage(ParserStage stage) {
        this.extendParserPipe(stage);
        return this;
    }

    public ParserPipe keepMinimumNodes(int nodeLimit, Ordering<? super Node> ordering) {
        this.extendParserPipe(new OrderedNodeCollector(GuardParserHandler.getInstance(), nodeLimit, ordering));
        return this.removeOrphanEdges();
    }

    public ParserPipe keepMinimumEdges(int edgeLimit, Ordering<? super Edge> ordering) {
        this.extendParserPipe(new OrderedEdgeCollector(GuardParserHandler.getInstance(), edgeLimit, ordering));
        return this;
    }

    public static <G extends NWBGraphPart> Ordering<G> getNaturalOrdering(String attributeName) {
        Function<G, Comparable> getter = ParserPipe.attributeGetter(attributeName, Comparable.class);
        return Ordering.natural().onResultOf(getter);
    }

    public ParserPipe requireNodeAttribute(final String attribute) {
        ParserPipe.checkNotReservedNodeAttribute(attribute);
        return this.filterNodes(new AttributePredicate(){

            public boolean apply(Map<String, Object> input) {
                return input.get(attribute) != null;
            }

            public String toString() {
                return String.format("Node.%s not null", attribute);
            }
        });
    }

    public ParserPipe requireEdgeAttribute(final String attribute) {
        ParserPipe.checkNotReservedEdgeAttribute(attribute);
        return this.filterEdges(new AttributePredicate(){

            public boolean apply(Map<String, Object> input) {
                return input.get(attribute) != null;
            }

            public String toString() {
                return String.format("Edge.%s not null", attribute);
            }
        });
    }

    public ParserPipe removeNodeAttribute(String attribute) {
        ParserPipe.checkNotReservedNodeAttribute(attribute);
        this.extendParserPipe(new NodeAttributeRemover(GuardParserHandler.getInstance(), attribute));
        return this;
    }

    public ParserPipe addNodeAttribute(String name, String type) {
        ParserPipe.checkNotReservedNodeAttribute(name);
        return this.addNodeAttributes((Map<String, String>)ImmutableMap.of((Object)name, (Object)type));
    }

    public ParserPipe addNodeAttributes(Map<String, String> schemaUpdates) {
        ParserPipe.checkForReservedNodeAttributes(schemaUpdates);
        this.extendParserPipe(new NodeAttributeAdder(GuardParserHandler.getInstance(), schemaUpdates));
        return this;
    }

    public ParserPipe addNodeAttribute(String name, String type, Object defaultValue) {
        ParserPipe.checkNotReservedNodeAttribute(name);
        this.extendParserPipe(new NodeAttributeDefaulter(GuardParserHandler.getInstance(), name, type, defaultValue));
        return this;
    }

    public ParserPipe addComputedNodeAttribute(String name, String type, FieldMakerFunction computer) {
        ParserPipe.checkNotReservedNodeAttribute(name);
        return this.addComputedNodeAttributes((Map<String, String>)ImmutableMap.of((Object)name, (Object)type), computer);
    }

    public ParserPipe addComputedNodeAttributes(Map<String, String> schemaUpdates, FieldMakerFunction computer) {
        ParserPipe.checkForReservedNodeAttributes(schemaUpdates);
        this.extendParserPipe(new NodeAttributeComputer.AdditiveNodeAttributeComputer(GuardParserHandler.getInstance(), schemaUpdates, computer));
        return this;
    }

    public ParserPipe injectNode(String label, Map<String, ? extends Object> attributes) {
        ParserPipe.checkForReservedNodeAttributes(attributes);
        this.extendParserPipe(NodeInjector.create(label, attributes));
        return this;
    }

    public ParserPipe renameNodeAttribute(String oldName, String newName) {
        ParserPipe.checkNotReservedNodeAttribute(oldName);
        ParserPipe.checkNotReservedNodeAttribute(newName);
        this.extendParserPipe(NodeAttributeRenamer.create(GuardParserHandler.getInstance(), (Map<String, String>)ImmutableMap.of((Object)oldName, (Object)newName)));
        return this;
    }

    public ParserStage outputTo(NWBFileParserHandler end) {
        this.extendParserPipe(ForwardingNWBHandler.create(end));
        return this.pipeHead;
    }

    public ParserStage outputToFile(File outFile) throws IOException {
        this.extendParserPipe(ForwardingNWBHandler.create(new NWBFileWriter(outFile)));
        return this.pipeHead;
    }

    public static ParserPipe create() {
        return new ParserPipe();
    }

    private ParserPipe() {
    }

    private static <G extends NWBGraphPart, T> Function<G, T> attributeGetter(final String attribute, final Class<T> clazz) {
        return new Function<G, T>(){

            public T apply(G input) {
                Preconditions.checkArgument((!((NWBGraphPart)input).isAttributeReserved(attribute) ? 1 : 0) != 0, (String)"Cannot use reserved attribute %s", (Object[])new Object[]{attribute});
                return clazz.cast(((NWBGraphPart)input).getAttribute(attribute));
            }
        };
    }

    private void extendParserPipe(NWBFileParserHandler tail) {
        ParserStage current = this.pipeHead;
        while (current.hasValidDelegate()) {
            if (current.delegate instanceof ParserStage) {
                current = (ParserStage)current.delegate;
                continue;
            }
            throw new IllegalStateException("Tried to extend a parsing pipeline with a closed end");
        }
        current.setNextStage(tail);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("pipe", (Object)this.pipeHead).toString();
    }

    private static void checkNotReservedNodeAttribute(String attribute) {
        Preconditions.checkArgument((!NWBFileProperty.NECESSARY_NODE_ATTRIBUTES.containsKey(attribute) ? 1 : 0) != 0, (String)"Node attribute \"%s\" is reserved.", (Object[])new Object[]{attribute});
    }

    private static void checkNotReservedEdgeAttribute(String attribute) {
        Preconditions.checkArgument((!NWBFileProperty.NECESSARY_EDGE_ATTRIBUTES.containsKey(attribute) ? 1 : 0) != 0, (String)"Edge attribute \"%s\" is reserved.", (Object[])new Object[]{attribute});
    }

    private static void checkForReservedNodeAttributes(Map<String, ?> map) {
        for (String attribute : map.keySet()) {
            ParserPipe.checkNotReservedNodeAttribute(attribute);
        }
    }
}

