/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.util.nwbfile.pipe;

import com.google.common.base.Objects;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.pipe.GuardParserHandler;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParserStage
implements NWBFileParserHandler {
    protected NWBFileParserHandler delegate;
    private boolean parsingStarted = false;

    public ParserStage(NWBFileParserHandler delegate) {
        this.setNextStage(delegate);
    }

    public ParserStage() {
        this.setNextStage(GuardParserHandler.getInstance());
    }

    void setNextStage(NWBFileParserHandler next) {
        if (this.parsingStarted) {
            throw new IllegalStateException("Pipeline setup changed after parsing started");
        }
        this.delegate = next;
    }

    @Override
    public void setNodeCount(int numberOfNodes) {
        this.parsingStarted = true;
        this.delegate.setNodeCount(numberOfNodes);
    }

    @Override
    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        this.parsingStarted = true;
        this.delegate.setNodeSchema(schema);
    }

    @Override
    public void addNode(int id, String label, Map<String, Object> attributes) {
        this.parsingStarted = true;
        this.delegate.addNode(id, label, attributes);
    }

    @Override
    public void setDirectedEdgeCount(int numberOfEdges) {
        this.parsingStarted = true;
        this.delegate.setDirectedEdgeCount(numberOfEdges);
    }

    @Override
    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.parsingStarted = true;
        this.delegate.setDirectedEdgeSchema(schema);
    }

    @Override
    public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        this.parsingStarted = true;
        this.delegate.addDirectedEdge(sourceNode, targetNode, attributes);
    }

    @Override
    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.parsingStarted = true;
        this.delegate.setUndirectedEdgeCount(numberOfEdges);
    }

    @Override
    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.parsingStarted = true;
        this.delegate.setUndirectedEdgeSchema(schema);
    }

    @Override
    public void addUndirectedEdge(int node1, int node2, Map<String, Object> attributes) {
        this.parsingStarted = true;
        this.delegate.addUndirectedEdge(node1, node2, attributes);
    }

    @Override
    public void addComment(String comment) {
        this.parsingStarted = true;
        this.delegate.addComment(comment);
    }

    @Override
    public void finishedParsing() {
        this.parsingStarted = true;
        this.delegate.finishedParsing();
    }

    @Override
    public boolean haltParsingNow() {
        this.parsingStarted = true;
        return this.delegate.haltParsingNow();
    }

    public String nextToString() {
        if (this.delegate == null) {
            return "none";
        }
        return this.delegate.toString();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("next", (Object)this.nextToString()).toString();
    }

    public boolean hasValidDelegate() {
        return this.delegate != null && this.delegate != GuardParserHandler.getInstance();
    }
}

