/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.drl;

import cern.colt.map.OpenIntDoubleHashMap;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NWBCoordMerger
implements NWBFileParserHandler {
    private String xpos;
    private String ypos;
    private NWBFileWriter out;
    private NWBFileParser parser;
    private File coordFile;
    private int numNodes = -1;
    private OpenIntDoubleHashMap idToXMap;
    private OpenIntDoubleHashMap idToYMap;

    public NWBCoordMerger(File coordFile, File srcNWBFile, String xpos, String ypos, File outputNWBFile) throws IOException {
        this.xpos = xpos;
        this.ypos = ypos;
        this.coordFile = coordFile;
        this.out = new NWBFileWriter(outputNWBFile);
        this.parser = new NWBFileParser(srcNWBFile);
    }

    public void merge() throws IOException, ParsingException {
        this.parser.parse((NWBFileParserHandler)this);
    }

    private void readCoords() throws IOException {
        this.idToXMap = new OpenIntDoubleHashMap();
        this.idToYMap = new OpenIntDoubleHashMap();
        if (this.numNodes > 0) {
            this.idToXMap.ensureCapacity(this.numNodes);
            this.idToYMap.ensureCapacity(this.numNodes);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.coordFile), "UTF-8"));
        String line = in.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line.trim());
            if (st.countTokens() > 1) {
                int id = Integer.parseInt(st.nextToken());
                double x = Double.parseDouble(st.nextToken());
                double y = Double.parseDouble(st.nextToken());
                this.idToXMap.put(id, x);
                this.idToYMap.put(id, y);
            }
            line = in.readLine();
        }
    }

    public void setNodeCount(int numberOfNodes) {
        this.numNodes = numberOfNodes;
        this.out.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        schema.put(this.xpos, "real");
        schema.put(this.ypos, "real");
        this.out.setNodeSchema(schema);
        if (this.idToXMap == null) {
            try {
                this.readCoords();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addNode(int id, String label, Map<String, Object> attributes) {
        if (this.idToXMap.containsKey(id)) {
            attributes.put(this.xpos, "" + this.idToXMap.get(id));
            attributes.put(this.ypos, "" + this.idToYMap.get(id));
        }
        this.out.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        this.out.addDirectedEdge(sourceNode, targetNode, attributes);
    }

    public void addUndirectedEdge(int node1, int node2, Map<String, Object> attributes) {
        this.out.addUndirectedEdge(node1, node2, attributes);
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
        this.out.setDirectedEdgeCount(numberOfEdges);
    }

    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.out.setDirectedEdgeSchema(schema);
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.out.setUndirectedEdgeCount(numberOfEdges);
    }

    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.out.setUndirectedEdgeSchema(schema);
    }

    public void addComment(String comment) {
        this.out.addComment(comment);
    }

    public void finishedParsing() {
        this.out.finishedParsing();
    }

    public boolean haltParsingNow() {
        return false;
    }
}

