/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.drl;

import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class NWBToSimFileHandler
extends NWBFileParserAdapter {
    public static final double DEFAULT_EDGE_WEIGHT = 1.0;
    private boolean useEdgeWeight;
    private String weightAttribute;
    private PrintWriter out;

    public NWBToSimFileHandler(boolean useEdgeWeight, String weightAttribute, OutputStream output) {
        this.useEdgeWeight = useEdgeWeight;
        this.weightAttribute = weightAttribute;
        this.out = new PrintWriter(output);
    }

    public void addUndirectedEdge(int source, int target, Map<String, Object> attributes) {
        if (this.useEdgeWeight) {
            if (attributes.containsKey(this.weightAttribute)) {
                this.out.println(this.createEdgeLine(source, target, attributes.get(this.weightAttribute)));
            }
        } else {
            this.out.println(this.createEdgeLine(source, target, "1.0"));
        }
    }

    private String createEdgeLine(int source, int target, Object weight) {
        return String.valueOf(source) + "\t" + target + "\t" + weight + "\n";
    }

    public void finishedParsing() {
        this.out.close();
    }
}

