/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.drl;

import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.nwb.visualization.drl.NWBCoordMerger;
import edu.iu.nwb.visualization.drl.NWBToSimFileHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.templates.staticexecutable.StaticExecutableAlgorithmFactory;
import org.cishell.utilities.FileUtilities;
import org.osgi.framework.BundleContext;

public class VxOrdAlgorithm
implements Algorithm {
    public static final String EDGE_CUT_ATTRIBUTE_ID = "edgeCut";
    public static final String OUTPUT_DATA_LABEL = "Laid out with DrL";
    public static final String TEMP_SIM_FILE_NAME = "temporarySIMFile";
    public static final String Y_POSITION_ATTRIBUTE_ID = "ypos";
    public static final String X_POSITION_ATTRIBUTE_ID = "xpos";
    public static final String VXORD_ALGORITHM_NAME = "vxord";
    public static final String EDGE_WEIGHT_ATTRIBUTE_ID = "edgeWeight";
    public static final double NO_CUT_EDGE_CUT_STRENGTH = 0.0;
    public static final String SHOULD_NOT_CUT_EDGES_ID = "shouldNotCutEdges";
    public static final String SIMINT_FILE_EXTENSION = "int";
    public static final String INTSIM_MIME_TYPE = "file:text/intsim";
    private Data[] data;
    private File inputNWBFile;
    private Dictionary<String, Object> parameters;
    private CIShellContext ciShellContext;
    private static StaticExecutableAlgorithmFactory staticAlgorithmFactory;

    public VxOrdAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext, BundleContext bundleContext) {
        this.data = data;
        this.inputNWBFile = (File)data[0].getData();
        this.parameters = parameters;
        this.ciShellContext = ciShellContext;
        if (staticAlgorithmFactory == null) {
            staticAlgorithmFactory = new StaticExecutableAlgorithmFactory(VXORD_ALGORITHM_NAME, bundleContext);
        }
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            boolean shouldNotCutEdges = (Boolean)this.parameters.get(SHOULD_NOT_CUT_EDGES_ID);
            if (shouldNotCutEdges) {
                this.parameters.put(EDGE_CUT_ATTRIBUTE_ID, new Double(0.0));
            }
            Data simData = this.createSimFileData();
            Data[] layoutData = this.generateLayoutData(simData);
            File outputNWBFile = this.writeLayoutDataToNWB(layoutData);
            return this.createOutData(outputNWBFile);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("There was a problem parsing the input data.", (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("There was a problem parsing the input data.", (Throwable)e);
        }
    }

    private Data createSimFileData() throws IOException, ParsingException, FileNotFoundException {
        String edgeWeightAttributeKey = (String)this.parameters.get(EDGE_WEIGHT_ATTRIBUTE_ID);
        boolean shouldUseEdgeWeight = true;
        if ("None (all edges treated equally)".equals(edgeWeightAttributeKey)) {
            shouldUseEdgeWeight = false;
        }
        File tmpSimFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)TEMP_SIM_FILE_NAME, (String)SIMINT_FILE_EXTENSION);
        NWBFileParser parser = new NWBFileParser(this.inputNWBFile);
        String weightAttr = (String)this.parameters.get(EDGE_WEIGHT_ATTRIBUTE_ID);
        parser.parse((NWBFileParserHandler)new NWBToSimFileHandler(shouldUseEdgeWeight, weightAttr, new FileOutputStream(tmpSimFile)));
        BasicData simData = new BasicData((Object)tmpSimFile, INTSIM_MIME_TYPE);
        return simData;
    }

    private Data[] generateLayoutData(Data simData) throws AlgorithmExecutionException {
        Data[] layoutData;
        Algorithm layoutAlg = staticAlgorithmFactory.createAlgorithm(new Data[]{simData}, this.parameters, this.ciShellContext);
        try {
            layoutData = layoutAlg.execute();
        }
        catch (AlgorithmExecutionException e) {
            throw new AlgorithmExecutionException("Unable to execute the DrL layout algorithm.", (Throwable)e);
        }
        return layoutData;
    }

    private File writeLayoutDataToNWB(Data[] layoutData) throws IOException, ParsingException {
        File outputNWBFile = NWBFileUtilities.createTemporaryNWBFile();
        File coordFile = (File)layoutData[0].getData();
        String xposAttr = (String)this.parameters.get(X_POSITION_ATTRIBUTE_ID);
        String yposAttr = (String)this.parameters.get(Y_POSITION_ATTRIBUTE_ID);
        if (layoutData == null) {
            throw new ParsingException("Layout Failed!");
        }
        NWBCoordMerger merger = new NWBCoordMerger(coordFile, this.inputNWBFile, xposAttr, yposAttr, outputNWBFile);
        merger.merge();
        return outputNWBFile;
    }

    private Data[] createOutData(File outputNWBFile) {
        BasicData outNWBData = new BasicData((Object)outputNWBFile, "file:text/nwb");
        Dictionary metadata = outNWBData.getMetadata();
        metadata.put("Label", OUTPUT_DATA_LABEL);
        metadata.put("Type", "Network");
        metadata.put("Parent", this.data[0]);
        return new Data[]{outNWBData};
    }
}

