/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.drl;

import edu.iu.nwb.util.nwbfile.GetMetadataAndCounts;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.NWBMetadataParsingException;
import edu.iu.nwb.visualization.drl.VxOrdAlgorithm;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.DataValidator;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ArrayListUtilities;
import org.cishell.utilities.MapUtilities;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.ObjectClassDefinition;

public class VxOrdAlgorithmFactory
implements AlgorithmFactory,
DataValidator,
ParameterMutator {
    public static final String USE_NO_EDGE_WEIGHT_TOKEN = "None (all edges treated equally)";
    public static final String EDGE_WEIGHT_ID = "edgeWeight";
    public static final Collection<String> EDGE_WEIGHT_KEYS_TO_ADD_TO_FRONT = Collections.unmodifiableList(Arrays.asList("None (all edges treated equally)"));
    private BundleContext bundleContext;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        return new VxOrdAlgorithm(data, parameters, ciShellContext, this.bundleContext);
    }

    public String validate(Data[] data) {
        GetMetadataAndCounts metadata;
        File nwbFile = (File)data[0].getData();
        try {
            metadata = NWBFileUtilities.parseMetadata((File)nwbFile);
        }
        catch (NWBMetadataParsingException nWBMetadataParsingException) {
            return "Invalid NWB file";
        }
        if (metadata.getUndirectedEdgeSchema() != null) {
            return "";
        }
        return "DrL can only process undirected networks.";
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        File nwbFile = (File)data[0].getData();
        try {
            GetMetadataAndCounts metadata = NWBFileUtilities.parseMetadata((File)nwbFile);
            LinkedHashMap edgeSchema = metadata.getUndirectedEdgeSchema();
            Collection edgeWeightOptions = MapUtilities.getValidKeysOfTypesInMap((Map)edgeSchema, (Collection)NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES, (Collection)NWBFileUtilities.DEFAULT_NUMBER_KEYS_TO_SKIP);
            edgeWeightOptions = ArrayListUtilities.unionCollections(EDGE_WEIGHT_KEYS_TO_ADD_TO_FRONT, (Collection)edgeWeightOptions, null);
            return MutateParameterUtilities.mutateToDropdown((ObjectClassDefinition)parameters, (String)EDGE_WEIGHT_ID, (Collection)edgeWeightOptions, (Collection)edgeWeightOptions);
        }
        catch (NWBMetadataParsingException nWBMetadataParsingException) {
            return parameters;
        }
    }
}

