/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.network.gephi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileCopyingException;
import org.cishell.utilities.FileUtilities;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.log.LogService;

public class GephiAlgorithm
implements Algorithm {
    public static final String GEPHI_EXT = ".gephi";
    public static final String GRAPHML_EXT = ".graphml";
    private static final String MAC_EXECUTABLE_PATH = "~/Applications/Gephi.app/Contents/MacOS/gephi";
    private static final String MAC_ALT_EXECUTABLE_PATH_1 = "/Applications/Gephi.app/Contents/MacOS/gephi";
    private static final String MAC_ALT_EXECUTABLE_PATH_2 = "~/Applications/gephi.app/Contents/MacOS/gephi";
    private static final String MAC_ALT_EXECUTABLE_PATH_3 = "/Applications/gephi.app/Contents/MacOS/gephi";
    private static String OS = System.getProperty("os.name").toLowerCase();
    private final Data[] data;
    private Program gephi;
    private final LogService logger;

    public GephiAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        this.data = data;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GephiAlgorithm.this.gephi = Program.findProgram((String)GephiAlgorithm.GEPHI_EXT);
            }
        });
        if (this.gephi == null) {
            String message = "Error: No program was associated with Gephi's .gephi file extension.  You need to have this file type associated with Gephi for this algorithm to work.\n";
            throw new AlgorithmCreationFailedException(message);
        }
    }

    public Data[] execute() throws AlgorithmExecutionException {
        List<File> files = this.fixFileExtForGephi();
        for (File file : files) {
            if (GephiAlgorithm.isMacOS()) {
                this.launchGephiOnMac(this.gephi, file);
                continue;
            }
            GephiAlgorithm.executeProgramWithFile(this.gephi, file);
        }
        return new Data[0];
    }

    private static boolean isMacOS() {
        return OS.indexOf("mac") >= 0;
    }

    private void launchGephiOnMac(Program program, File file) {
        String executable = null;
        if (new File(MAC_EXECUTABLE_PATH).exists()) {
            executable = MAC_EXECUTABLE_PATH;
        } else if (new File(MAC_ALT_EXECUTABLE_PATH_1).exists()) {
            executable = MAC_ALT_EXECUTABLE_PATH_1;
        } else if (new File(MAC_ALT_EXECUTABLE_PATH_2).exists()) {
            executable = MAC_ALT_EXECUTABLE_PATH_2;
        } else if (new File(MAC_ALT_EXECUTABLE_PATH_3).exists()) {
            executable = MAC_ALT_EXECUTABLE_PATH_3;
        }
        if (executable != null) {
            try {
                Runtime.getRuntime().exec("chmod 555 " + file.getAbsolutePath());
                Runtime.getRuntime().exec(String.valueOf(executable) + " " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                String error = "An error occured while try to launch Gephi. \nYou can save the network as .graphml file extension and load it into Gephi manually.";
                this.logger.log(1, error);
            }
        } else {
            String error = "An error occured while try to launch Gephi. Please make sure /Applications/Gephi.app exist.\nAlternately, you can save the network as .graphml file extension and load it into Gephi manually.";
            this.logger.log(1, error);
        }
    }

    private static void executeProgramWithFile(final Program program, final File file) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                program.execute(file.getAbsolutePath());
            }
        });
    }

    private List<File> fixFileExtForGephi() throws AlgorithmExecutionException {
        ArrayList<File> files = new ArrayList<File>(this.data.length);
        Data[] dataArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                File graphmlFile;
                Data datum = dataArray[n2];
                try {
                    graphmlFile = File.createTempFile("Graphml-for-gephi", GRAPHML_EXT);
                }
                catch (IOException e) {
                    String error = "A temp file could not be created to create the graphml file for Gephi.\n" + e.getMessage();
                    throw new AlgorithmExecutionException(error);
                }
                File datumFile = (File)datum.getData();
                try {
                    FileUtilities.copyFile((File)datumFile, (File)graphmlFile);
                }
                catch (FileCopyingException e) {
                    String error = "An error occured while copying " + datumFile.getName() + " to a temporary file.  It will be ignored and " + "Gephi will not run if it was the only file to be opened.\n" + e.getMessage();
                    this.logger.log(1, error);
                    break block5;
                }
                files.add(graphmlFile);
            }
            ++n2;
        }
        return files;
    }
}

