/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common;

import edu.iu.nwb.visualization.prefuse.beta.common.Constants;
import edu.iu.nwb.visualization.prefuse.beta.common.Indirection;
import edu.iu.nwb.visualization.prefuse.beta.common.PrefuseBetaVisualization;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendAction;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendDataColorAction;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendDataShapeAction;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendDataSizeAction;
import edu.iu.nwb.visualization.prefuse.beta.common.expression.SmartValueExpression;
import edu.iu.nwb.visualization.prefuse.beta.common.expression.ToDoubleExpression;
import edu.iu.nwb.visualization.prefuse.beta.common.renderer.ShapeLabelRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.freehep.graphicsio.ps.PSGraphics2D;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.assignment.ShapeAction;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.expression.Expression;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public abstract class AbstractVisualization
implements PrefuseBetaVisualization {
    private static final JFileChooser chooser = new JFileChooser();
    protected static final String LAYOUT = "layout";
    protected static final String DRAW = "draw";
    private static final String all = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    private Visualization visualization;

    protected abstract Action getInitialDrawActions(String var1, Visualization var2, Dictionary var3);

    protected abstract Action getLayoutActions(String var1, Visualization var2, Dictionary var3);

    protected abstract Component arrangeComponents(Display var1, JComponent var2);

    protected abstract void setTitle(JFrame var1);

    @Override
    public Graph create(Graph graph, Dictionary parameters) {
        EdgeRenderer edgeRenderer;
        UILib.setPlatformLookAndFeel();
        ArrayList<LegendAction> legendActions = new ArrayList<LegendAction>();
        Box legends = Box.createHorizontalBox();
        legends.add(Box.createHorizontalStrut(5));
        Container legendBox = null;
        this.visualization = new Visualization();
        ShapeLabelRenderer nodeRenderer = new ShapeLabelRenderer();
        DefaultRendererFactory rendererFactory = new DefaultRendererFactory((Renderer)nodeRenderer);
        if (graph.isDirected()) {
            edgeRenderer = new EdgeRenderer(0, 1);
            edgeRenderer.setArrowHeadSize(6, 9);
        } else {
            edgeRenderer = new EdgeRenderer(0, 0);
        }
        rendererFactory.setDefaultEdgeRenderer((Renderer)edgeRenderer);
        this.visualization.setRendererFactory((RendererFactory)rendererFactory);
        this.visualization.addGraph(all, graph);
        this.visualization.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        String nodeColorField = (String)parameters.get("nodeColor");
        String ringColorField = (String)parameters.get("ringColor");
        String edgeSizeField = (String)parameters.get("edgeSize");
        String edgeColorField = (String)parameters.get("edgeColor");
        String nodeShapeField = (String)parameters.get("nodeShape");
        String nodeSizeField = (String)parameters.get("nodeSize");
        int white = ColorLib.rgb((int)255, (int)255, (int)255);
        int black = ColorLib.rgb((int)0, (int)0, (int)0);
        ActionList draw = new ActionList();
        Action drawActions = this.getInitialDrawActions(all, this.visualization, parameters);
        if (drawActions != null) {
            draw.add(drawActions);
        }
        draw.add((Action)new ColorAction(edges, VisualItem.FILLCOLOR, black));
        if (!"".equals(nodeColorField)) {
            SmartValueExpression nodeFillExpression = new SmartValueExpression(nodeColorField, Indirection.getExample(graph.getNodes(), nodeColorField));
            Indirection nodeFillIndirection = new Indirection(this.visualization, nodes, (Expression)nodeFillExpression);
            LegendDataColorAction nodeFillAction = new LegendDataColorAction(nodes, nodeFillIndirection.getField(), nodeFillIndirection.getDataType(), VisualItem.FILLCOLOR, nodeFillIndirection.getPalette(), nodeFillExpression.getColumnName(), "Node Color");
            draw.add((Action)nodeFillAction);
            legendActions.add(nodeFillAction);
        } else {
            draw.add((Action)new ColorAction(nodes, VisualItem.FILLCOLOR, white));
        }
        if (!"".equals(edgeColorField)) {
            SmartValueExpression edgeColorExpression = new SmartValueExpression(edgeColorField, Indirection.getExample(graph.getEdges(), edgeColorField));
            Indirection edgeColorIndirection = new Indirection(this.visualization, edges, (Expression)edgeColorExpression);
            LegendDataColorAction edgeColorAction = new LegendDataColorAction(edges, edgeColorIndirection.getField(), edgeColorIndirection.getDataType(), VisualItem.STROKECOLOR, edgeColorIndirection.getPalette(), edgeColorExpression.getColumnName(), "Edge Color");
            draw.add((Action)edgeColorAction);
            legendActions.add(edgeColorAction);
        } else {
            draw.add((Action)new ColorAction(edges, VisualItem.STROKECOLOR, black));
        }
        if (!"".equals(ringColorField)) {
            SmartValueExpression ringColorExpression = new SmartValueExpression(ringColorField, Indirection.getExample(graph.getNodes(), ringColorField));
            Indirection ringColorIndirection = new Indirection(this.visualization, nodes, (Expression)ringColorExpression);
            LegendDataColorAction ringColorAction = new LegendDataColorAction(nodes, ringColorIndirection.getField(), ringColorIndirection.getDataType(), VisualItem.STROKECOLOR, ringColorIndirection.getPalette(), ringColorExpression.getColumnName(), "Ring Color");
            draw.add((Action)ringColorAction);
            legendActions.add(ringColorAction);
        } else {
            draw.add((Action)new ColorAction(nodes, VisualItem.STROKECOLOR, black));
        }
        if (!"".equals(edgeSizeField)) {
            ToDoubleExpression edgeSizeExpression = new ToDoubleExpression(edgeSizeField);
            Indirection edgeSizeIndirection = new Indirection(this.visualization, edges, (Expression)edgeSizeExpression);
            LegendDataSizeAction edgeSizeAction = new LegendDataSizeAction(edges, edgeSizeIndirection.getField(), edgeSizeExpression.getColumnName(), "Edge Width");
            draw.add((Action)edgeSizeAction);
            legendActions.add(edgeSizeAction);
        }
        if (!"".equals(nodeSizeField)) {
            ToDoubleExpression nodeSizeExpression = new ToDoubleExpression(nodeSizeField);
            Indirection nodeSizeIndirection = new Indirection(this.visualization, nodes, (Expression)nodeSizeExpression);
            LegendDataSizeAction nodeSizeAction = new LegendDataSizeAction(nodes, nodeSizeIndirection.getField(), nodeSizeExpression.getColumnName(), "Node Size");
            draw.add((Action)nodeSizeAction);
            legendActions.add(nodeSizeAction);
        }
        if (!"".equals(nodeShapeField)) {
            SmartValueExpression nodeShapeExpression = new SmartValueExpression(nodeShapeField, Indirection.getExample(graph.getNodes(), nodeShapeField));
            Indirection nodeShapeIndirection = new Indirection(this.visualization, nodes, (Expression)nodeShapeExpression);
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[2] = 5;
            nArray[3] = 2;
            nArray[4] = 6;
            LegendDataShapeAction nodeShapeAction = new LegendDataShapeAction(nodes, nodeShapeIndirection.getField(), nArray, nodeShapeExpression.getColumnName(), "Node Shape");
            draw.add((Action)nodeShapeAction);
            legendActions.add(nodeShapeAction);
        } else {
            draw.add((Action)new ShapeAction(nodes, 1));
        }
        draw.add((Action)new FontAction(nodes, Constants.LABEL_FONT));
        draw.add((Action)new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.gray((int)0)));
        Action layout = this.getLayoutActions(all, this.visualization, parameters);
        this.visualization.putAction(DRAW, (Action)draw);
        this.visualization.putAction(LAYOUT, layout);
        this.visualization.runAfter(DRAW, LAYOUT);
        Indirection.resetPalette();
        class LegendComparator
        implements Comparator {
            LegendComparator() {
            }

            public int compare(Object one, Object two) {
                LegendAction first = (LegendAction)one;
                LegendAction second = (LegendAction)two;
                Integer firstSize = new Integer(first.getLegendSize());
                Integer secondSize = new Integer(second.getLegendSize());
                return firstSize.compareTo(secondSize);
            }
        }
        Collections.sort(legendActions, new LegendComparator());
        Collections.reverse(legendActions);
        int overflow = 5;
        int current = 6;
        int maxHeight = 0;
        Iterator legendActionsIter = legendActions.iterator();
        while (legendActionsIter.hasNext()) {
            if (current >= overflow) {
                if (legendBox != null) {
                    legendBox.add(Box.createVerticalGlue());
                    ((JComponent)legendBox).setMaximumSize(new Dimension(Integer.MAX_VALUE, maxHeight * 2));
                }
                legendBox = new Box(3);
                ((JComponent)legendBox).setAlignmentY(0.0f);
                legends.add(legendBox);
                current = 0;
                maxHeight = 0;
            } else {
                legendBox.add(Box.createVerticalStrut(1));
                legendBox.add(new JSeparator());
                legendBox.add(Box.createVerticalStrut(1));
                maxHeight += 3;
            }
            LegendAction action = (LegendAction)legendActionsIter.next();
            JComponent legend = action.getLegend();
            int legendSize = action.getLegendSize();
            legend.setMaximumSize(new Dimension(Integer.MAX_VALUE, 13 * legendSize));
            maxHeight += legend.getMaximumSize().height;
            legend.setAlignmentX(0.0f);
            legendBox.add(legend);
            current += legendSize;
        }
        if (legendBox != null) {
            legendBox.add(Box.createVerticalGlue());
            ((JComponent)legendBox).setMaximumSize(new Dimension(Integer.MAX_VALUE, maxHeight * 2));
        }
        final Display display = new Display(this.visualization);
        display.setSize(700, 700);
        display.setBackground(Color.WHITE);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        ZoomToFitControl zoomToFitControl = new ZoomToFitControl(edges, 8);
        zoomToFitControl.setMargin(25);
        display.addControlListener((Control)zoomToFitControl);
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new NeighborHighlightControl());
        this.visualization.run(DRAW);
        final JFrame frame = new JFrame();
        JPanel contentPane = new JPanel(new BorderLayout());
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == 'e') {
                    AbstractVisualization.this.exportGraphToFile(frame, display);
                }
            }
        };
        frame.addKeyListener(keyAdapter);
        display.addKeyListener((KeyListener)keyAdapter);
        JButton exportButton = new JButton("Export Image to .eps File");
        exportButton.setMnemonic(69);
        exportButton.setActionCommand("export");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("export".equals(e.getActionCommand())) {
                    AbstractVisualization.this.exportGraphToFile(frame, display);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(legends);
        scrollPane.setPreferredSize(new Dimension(100, Math.min(180, maxHeight * 2)));
        display.setOpaque(true);
        Component thePanel = this.arrangeComponents(display, scrollPane);
        contentPane.add((Component)exportButton, "North");
        contentPane.add(thePanel, "Center");
        this.setTitle(frame);
        frame.setContentPane(contentPane);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
        return null;
    }

    private void exportGraphToFile(JFrame frame, Display display) {
        int option = chooser.showSaveDialog(frame);
        if (option == 0) {
            Properties properties = new Properties();
            properties.setProperty("PageSize", "A5");
            try {
                PSGraphics2D graphics = new PSGraphics2D(chooser.getSelectedFile(), display.getSize());
                graphics.setProperties(properties);
                graphics.startExport();
                display.printAll((Graphics)graphics);
                graphics.endExport();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

