/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common;

import java.util.Random;
import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.DataLib;

public class Indirection {
    private String createdField = "_x_nwb" + new Random().nextInt();
    private Expression expression;
    private TupleSet visGroup;
    private int dataType = -1;
    private static int currentColorIndex = 0;
    private static int[] interpolationPalette = new int[13];

    static {
        Indirection.interpolationPalette[0] = ColorLib.rgb((int)0, (int)255, (int)0);
        System.arraycopy(ColorLib.getCategoryPalette((int)12), 0, interpolationPalette, 1, 12);
    }

    public Indirection(Visualization visualization, String group, Expression expression) {
        this.expression = expression;
        this.visGroup = visualization.getGroup(group);
        this.visGroup.addColumn(this.createdField, expression);
    }

    public int getDataType() {
        if (this.dataType == -1) {
            Tuple example = (Tuple)this.visGroup.tuples().next();
            Class expressionClass = this.expression.getType(example.getSchema());
            this.dataType = expressionClass.equals(String.class) ? 0 : 2;
        }
        return this.dataType;
    }

    public String getField() {
        return this.createdField;
    }

    public static Object getExample(TupleSet tuples, String column) {
        Tuple prototype = (Tuple)tuples.tuples().next();
        if (prototype.getSchema().getColumnIndex(column) != -1) {
            return prototype.get(column);
        }
        return null;
    }

    public int[] getPalette() {
        int[] palette;
        int type = this.getDataType();
        if (type == 2) {
            palette = ColorLib.getInterpolatedPalette((int)ColorLib.rgb((int)0, (int)0, (int)0), (int)interpolationPalette[currentColorIndex % 12]);
            ++currentColorIndex;
        } else {
            int size = DataLib.ordinalArray((TupleSet)this.visGroup, (String)this.createdField).length;
            palette = ColorLib.getCategoryPalette((int)size);
        }
        return palette;
    }

    public static void resetPalette() {
        currentColorIndex = 0;
    }
}

