/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common;

import edu.iu.nwb.visualization.prefuse.beta.common.PrefuseBetaVisualization;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Graph;
import prefuse.data.Schema;

public abstract class PrefuseBetaAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    private String[] createKeyArray(Schema schema) {
        String[] keys = new String[schema.getColumnCount() + 1];
        keys[0] = "";
        int ii = 1;
        while (ii <= schema.getColumnCount()) {
            keys[ii] = schema.getColumnName(ii - 1);
            ++ii;
        }
        return keys;
    }

    public Algorithm createAlgorithm(Data[] dm, Dictionary parameters, CIShellContext context) {
        return new VisualizationAlgorithm(dm, parameters, context, this.getVisualization());
    }

    protected abstract PrefuseBetaVisualization getVisualization();

    protected AttributeDefinition[] createAttributeDefinitions(AttributeDefinition[] oldAttributeDefinitions, String[] nodeAttributesArray, String[] edgeAttributesArray) {
        int numAttributeDefinitions = oldAttributeDefinitions.length;
        AttributeDefinition[] newAttributeDefinitions = new AttributeDefinition[numAttributeDefinitions];
        int ii = 0;
        while (ii < numAttributeDefinitions) {
            String id = oldAttributeDefinitions[ii].getID();
            newAttributeDefinitions[ii] = id.equals("nodeSize") ? new BasicAttributeDefinition("nodeSize", "Node Size", "The label for the node size property", 1, nodeAttributesArray, nodeAttributesArray) : (id.equals("edgeSize") ? new BasicAttributeDefinition("edgeSize", "Edge Size", "The label for the edge size property", 1, edgeAttributesArray, edgeAttributesArray) : (id.equals("nodeColor") ? new BasicAttributeDefinition("nodeColor", "Node Color", "The label for the node color property", 1, nodeAttributesArray, nodeAttributesArray) : (id.equals("edgeColor") ? new BasicAttributeDefinition("edgeColor", "Edge Color", "The label for the edge color property", 1, edgeAttributesArray, edgeAttributesArray) : (id.equals("ringColor") ? new BasicAttributeDefinition("ringColor", "Ring Color", "The label for the ring color property", 1, nodeAttributesArray, nodeAttributesArray) : (id.equals("nodeShape") ? new BasicAttributeDefinition("nodeShape", "Node Shape", "The label for the node shape property", 1, nodeAttributesArray, nodeAttributesArray) : oldAttributeDefinitions[ii])))));
            ++ii;
        }
        return newAttributeDefinitions;
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition objectClassDefinition;
        Graph graph = (Graph)data[0].getData();
        try {
            objectClassDefinition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), parameters.getIcon(16));
        }
        catch (IOException iOException) {
            objectClassDefinition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), null);
        }
        String[] nodeAttributesArray = this.createKeyArray(graph.getNodeTable().getSchema());
        String[] edgeAttributesArray = this.createKeyArray(graph.getEdgeTable().getSchema());
        AttributeDefinition[] oldRequiredAttributes = parameters.getAttributeDefinitions(1);
        AttributeDefinition[] newRequiredAttributes = this.createAttributeDefinitions(oldRequiredAttributes, nodeAttributesArray, edgeAttributesArray);
        AttributeDefinition[] oldOptionalAttributes = parameters.getAttributeDefinitions(2);
        AttributeDefinition[] newOptionalAttributes = this.createAttributeDefinitions(oldOptionalAttributes, nodeAttributesArray, edgeAttributesArray);
        int ii = 0;
        while (ii < newRequiredAttributes.length) {
            objectClassDefinition.addAttributeDefinition(1, newRequiredAttributes[ii]);
            ++ii;
        }
        ii = 0;
        while (ii < newOptionalAttributes.length) {
            objectClassDefinition.addAttributeDefinition(2, newOptionalAttributes[ii]);
            ++ii;
        }
        return objectClassDefinition;
    }

    private class VisualizationAlgorithm
    implements Algorithm {
        private Data[] dm;
        private Dictionary parameters;
        private PrefuseBetaVisualization visualization;

        public VisualizationAlgorithm(Data[] dm, Dictionary parameters, CIShellContext ciContext, PrefuseBetaVisualization visualization) {
            this.dm = dm;
            this.parameters = parameters;
            this.visualization = visualization;
        }

        public Data[] execute() {
            Graph graph = (Graph)this.dm[0].getData();
            Object label = this.parameters.get("label");
            if (label == null || "".equals(label)) {
                this.parameters.put("label", "label");
            }
            this.visualization.create(graph, this.parameters);
            return null;
        }
    }
}

