/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.action;

import edu.iu.nwb.visualization.prefuse.beta.common.Constants;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prefuse.action.assignment.DataColorAction;
import prefuse.data.DataTypeException;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.DataLib;

public class LegendDataColorAction
extends DataColorAction
implements LegendAction {
    private String dataField;
    private int[] palette;
    private String column;
    private String context;
    private int size = 0;

    public LegendDataColorAction(String group, String dataField, int dataType, String colorField, int[] palette, String column, String context) {
        super(group, dataField, dataType, colorField, palette);
        this.dataField = dataField;
        this.palette = palette;
        this.column = column;
        this.context = context;
    }

    @Override
    public JComponent getLegend() {
        Box legend = Box.createVerticalBox();
        legend.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        final TupleSet tuples = this.getVisualization().getGroup(this.m_group);
        if (this.getDataType() == 2) {
            JLabel maxLabel;
            JLabel minLabel;
            JPanel canvas;
            this.size = 2;
            double min = 0.0;
            double max = 1.0;
            boolean bad = false;
            try {
                min = DataLib.min((TupleSet)tuples, (String)this.dataField).getDouble(this.dataField);
                max = DataLib.max((TupleSet)tuples, (String)this.dataField).getDouble(this.dataField);
            }
            catch (DataTypeException dataTypeException) {
                bad = true;
            }
            catch (NullPointerException nullPointerException) {
                bad = true;
            }
            if (this.getScale() == 3) {
                final ColorMap colorMap = new ColorMap(this.palette, 0.0, 1.0);
                canvas = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paint(Graphics g) {
                        Graphics2D graphics = (Graphics2D)g;
                        Object[] valueArray = DataLib.ordinalArray((TupleSet)tuples, (String)LegendDataColorAction.this.dataField);
                        int width = this.getWidth() / valueArray.length - 1;
                        int valueIndex = 0;
                        while (valueIndex < valueArray.length) {
                            int x = width * valueIndex;
                            Color color = ColorLib.getColor((int)colorMap.getColor(((Double)valueArray[valueIndex]).doubleValue()));
                            graphics.setColor(color);
                            graphics.fillRect(x, 0, width, this.getHeight());
                            ++valueIndex;
                        }
                    }
                };
            } else {
                canvas = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paint(Graphics g) {
                        Graphics2D graphics = (Graphics2D)g;
                        Color startColor = ColorLib.getColor((int)LegendDataColorAction.this.palette[0]);
                        Color endColor = ColorLib.getColor((int)LegendDataColorAction.this.palette[LegendDataColorAction.this.palette.length - 1]);
                        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, this.getWidth(), 0.0f, endColor);
                        graphics.setPaint(gradient);
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                };
            }
            canvas.setBounds(0, 0, 50, 13);
            canvas.setMinimumSize(new Dimension(39, 0));
            JLabel fieldLabel = new JLabel(String.valueOf(this.context) + " (" + this.column + ")");
            fieldLabel.setFont(Constants.FIELD_SPECIFYING_FONT);
            JPanel titlePanel = new JPanel(new FlowLayout(0));
            titlePanel.add(fieldLabel);
            legend.add((Component)titlePanel, "North");
            JPanel continuumPanel = new JPanel(new FlowLayout(0));
            if (bad) {
                minLabel = new JLabel("error");
                minLabel.setFont(Constants.EMPTY_FIELD_FONT);
            } else {
                minLabel = new JLabel("" + min);
                minLabel.setFont(Constants.FIELD_VALUE_FONT);
            }
            continuumPanel.add(minLabel);
            continuumPanel.add(canvas);
            if (bad) {
                maxLabel = new JLabel("error");
                maxLabel.setFont(Constants.EMPTY_FIELD_FONT);
            } else {
                maxLabel = new JLabel("" + max);
                maxLabel.setFont(Constants.FIELD_VALUE_FONT);
            }
            continuumPanel.add(maxLabel);
            legend.add((Component)continuumPanel, "South");
        } else {
            ++this.size;
            JLabel label = new JLabel(String.valueOf(this.context) + " (" + this.column + ")");
            label.setFont(Constants.FIELD_SPECIFYING_FONT);
            JPanel titlePanel = new JPanel(new FlowLayout(0));
            titlePanel.add(label);
            legend.add(titlePanel);
            legend.add(Box.createVerticalStrut(1));
            final ColorMap colorMap = new ColorMap(null, 0.0, 1.0);
            colorMap.setColorPalette(this.palette);
            double[] distribution = this.getDistribution();
            colorMap.setMinValue(distribution[0]);
            colorMap.setMaxValue(distribution[1]);
            Object[] values = DataLib.ordinalArray((TupleSet)tuples, (String)this.dataField);
            int valueIndex = 0;
            while (valueIndex < values.length) {
                JLabel itemLabel;
                ++this.size;
                final int tempIndex = valueIndex;
                JPanel canvas = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paint(Graphics g) {
                        Graphics2D graphics = (Graphics2D)g;
                        Color color = ColorLib.getColor((int)colorMap.getColor((double)tempIndex));
                        graphics.setColor(color);
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                };
                canvas.setBounds(0, 0, 13, 13);
                JPanel keyValue = new JPanel(new FlowLayout(0));
                Object objectValue = values[valueIndex];
                String value = objectValue == null ? "" : objectValue.toString();
                if ("".equals(value)) {
                    itemLabel = new JLabel(" (empty)");
                    itemLabel.setFont(Constants.EMPTY_FIELD_FONT);
                } else {
                    itemLabel = new JLabel(" " + value);
                    itemLabel.setFont(Constants.FIELD_VALUE_FONT);
                }
                keyValue.add(canvas);
                keyValue.add(itemLabel);
                legend.add(keyValue);
                legend.add(Box.createVerticalStrut(1));
                ++valueIndex;
            }
        }
        return legend;
    }

    @Override
    public int getLegendSize() {
        this.getLegend();
        return this.size;
    }
}

