/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.action;

import edu.iu.nwb.visualization.prefuse.beta.common.Constants;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendAction;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prefuse.action.assignment.DataShapeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.render.ShapeRenderer;
import prefuse.util.DataLib;

public class LegendDataShapeAction
extends DataShapeAction
implements LegendAction {
    private int size = 0;
    private String column;
    private String context;

    public LegendDataShapeAction(String group, String field, int[] shapes, String indirectedColumn, String context) {
        super(group, field, shapes);
        this.column = indirectedColumn;
        this.context = context;
    }

    @Override
    public JComponent getLegend() {
        Box legend = new Box(3);
        ++this.size;
        JLabel label = new JLabel(String.valueOf(this.context) + " (" + this.column + ")");
        label.setFont(Constants.FIELD_SPECIFYING_FONT);
        JPanel titlePanel = new JPanel(new FlowLayout(0));
        titlePanel.add(label);
        legend.add(titlePanel);
        legend.add(Box.createVerticalStrut(1));
        Object[] values = DataLib.ordinalArray((TupleSet)this.m_vis.getGroup(this.m_group), (String)this.m_dataField);
        int valueIndex = 0;
        while (valueIndex < values.length) {
            JLabel itemLabel;
            ++this.size;
            final int tempIndex = valueIndex;
            JPanel canvas = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Graphics2D graphics = (Graphics2D)g;
                    Shape shape = LegendDataShapeAction.this.getSpecifiedShape(LegendDataShapeAction.this.m_palette[tempIndex % LegendDataShapeAction.this.m_palette.length], 1.0, 1.0, this.getWidth() - 3);
                    graphics.setPaint(Color.BLACK);
                    graphics.draw(shape);
                }
            };
            canvas.setBackground(Color.WHITE);
            canvas.setBounds(0, 0, 13, 13);
            JPanel keyValue = new JPanel(new FlowLayout(0));
            Object objectValue = values[valueIndex];
            String value = objectValue == null ? "" : objectValue.toString();
            if ("".equals(value)) {
                itemLabel = new JLabel(" (empty)");
                itemLabel.setFont(Constants.EMPTY_FIELD_FONT);
            } else {
                itemLabel = new JLabel(" " + value);
                itemLabel.setFont(Constants.FIELD_VALUE_FONT);
            }
            keyValue.add(canvas);
            keyValue.add(itemLabel);
            legend.add(keyValue);
            legend.add(Box.createVerticalStrut(1));
            ++valueIndex;
        }
        return legend;
    }

    private Shape getSpecifiedShape(int shape, double x, double y, double width) {
        ShapeRenderer shaper = new ShapeRenderer();
        switch (shape) {
            case -1: {
                return null;
            }
            case 0: {
                return shaper.rectangle(x, y, width, width);
            }
            case 1: {
                return shaper.ellipse(x, y, width, width);
            }
            case 5: {
                return shaper.triangle_up((float)x, (float)y, (float)width);
            }
            case 6: {
                return shaper.triangle_down((float)x, (float)y, (float)width);
            }
            case 7: {
                return shaper.triangle_left((float)x, (float)y, (float)width);
            }
            case 8: {
                return shaper.triangle_right((float)x, (float)y, (float)width);
            }
            case 3: {
                return shaper.cross((float)x, (float)y, (float)width);
            }
            case 4: {
                return shaper.star((float)x, (float)y, (float)width);
            }
            case 9: {
                return shaper.hexagon((float)x, (float)y, (float)width);
            }
            case 2: {
                return shaper.diamond((float)x, (float)y, (float)width);
            }
        }
        throw new IllegalStateException("Unknown shape type: " + shape);
    }

    @Override
    public int getLegendSize() {
        this.getLegend();
        return this.size;
    }
}

