/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.action;

import edu.iu.nwb.visualization.prefuse.beta.common.Constants;
import edu.iu.nwb.visualization.prefuse.beta.common.action.LegendAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prefuse.action.assignment.DataSizeAction;
import prefuse.data.DataTypeException;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;

public class LegendDataSizeAction
extends DataSizeAction
implements LegendAction {
    private String context;
    private String fakeColumn;
    private String column;
    private int size = 2;

    public LegendDataSizeAction(String group, String fakeColumn, String column, String context) {
        super(group, fakeColumn);
        this.fakeColumn = fakeColumn;
        this.column = column;
        this.context = context;
    }

    @Override
    public JComponent getLegend() {
        JLabel maxLabel;
        JLabel minLabel;
        TupleSet tuples = this.getVisualization().getGroup(this.m_group);
        Box legend = new Box(3);
        double min = 0.0;
        double max = 1.0;
        boolean bad = false;
        try {
            min = DataLib.min((TupleSet)tuples, (String)this.fakeColumn).getDouble(this.fakeColumn);
            max = DataLib.max((TupleSet)tuples, (String)this.fakeColumn).getDouble(this.fakeColumn);
        }
        catch (DataTypeException dataTypeException) {
            bad = true;
        }
        catch (NullPointerException nullPointerException) {
            bad = true;
        }
        final double tempMin = min;
        final double tempMax = max;
        final boolean badNumbers = bad;
        JPanel canvas = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                Graphics2D graphics = (Graphics2D)g;
                int startSize = badNumbers ? this.getHeight() : (int)((double)this.getHeight() * tempMin / tempMax);
                Polygon polygon = new Polygon();
                polygon.addPoint(this.getWidth(), this.getHeight());
                polygon.addPoint(this.getWidth(), 0);
                int pinch = (this.getHeight() - startSize) / 2;
                polygon.addPoint(0, pinch);
                polygon.addPoint(0, this.getHeight() - pinch);
                graphics.setColor(Color.DARK_GRAY);
                graphics.fillPolygon(polygon);
            }
        };
        canvas.setBounds(0, 0, 50, 13);
        canvas.setMinimumSize(new Dimension(39, 0));
        JLabel fieldLabel = new JLabel(String.valueOf(this.context) + " (" + this.column + ")", 2);
        fieldLabel.setFont(Constants.FIELD_SPECIFYING_FONT);
        JPanel titlePanel = new JPanel(new FlowLayout(0));
        titlePanel.add(fieldLabel);
        legend.add(titlePanel);
        legend.add(Box.createVerticalStrut(1));
        JPanel continuumPanel = new JPanel(new FlowLayout(0));
        if (bad) {
            minLabel = new JLabel("error");
            minLabel.setFont(Constants.EMPTY_FIELD_FONT);
        } else {
            minLabel = new JLabel("" + min);
            minLabel.setFont(Constants.FIELD_VALUE_FONT);
        }
        continuumPanel.add(minLabel);
        continuumPanel.add(canvas);
        if (bad) {
            maxLabel = new JLabel("error");
            maxLabel.setFont(Constants.EMPTY_FIELD_FONT);
        } else {
            maxLabel = new JLabel("" + max);
            maxLabel.setFont(Constants.FIELD_VALUE_FONT);
        }
        continuumPanel.add(maxLabel);
        legend.add(continuumPanel);
        return legend;
    }

    @Override
    public int getLegendSize() {
        return this.size;
    }
}

