/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.ColumnExpression;

public class SmartValueExpression
extends ColumnExpression {
    private Object example;

    public SmartValueExpression(String column, Object example) {
        super(column);
        this.example = example;
    }

    public double getDouble(Tuple t) {
        if (super.getType(t.getSchema()) == Double.TYPE) {
            return super.getDouble(t);
        }
        double value = Double.parseDouble(super.get(t).toString());
        return value;
    }

    public Object get(Tuple t) {
        if (this.getType(t.getSchema()) == Double.TYPE) {
            return new Double(this.getDouble(t));
        }
        Object object = super.get(t);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public Class getType(Schema s) {
        if (this.example == null) {
            return String.class;
        }
        try {
            Double.parseDouble(this.example.toString());
            return Double.TYPE;
        }
        catch (NumberFormatException numberFormatException) {
            return String.class;
        }
    }
}

