/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.expression;

import prefuse.data.DataTypeException;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.ColumnExpression;

public class ToDoubleExpression
extends ColumnExpression {
    public ToDoubleExpression(String column) {
        super(column);
    }

    public double getDouble(Tuple t) {
        double value;
        if (super.getType(t.getSchema()) == Double.TYPE) {
            try {
                return super.getDouble(t);
            }
            catch (DataTypeException dataTypeException) {
                return 1.0;
            }
        }
        try {
            Object valueObject = super.get(t);
            value = valueObject == null ? 1.0 : Double.parseDouble(valueObject.toString());
        }
        catch (NumberFormatException numberFormatException) {
            value = 1.0;
        }
        return value;
    }

    public Object get(Tuple t) {
        return new Double(this.getDouble(t));
    }

    public Class getType(Schema s) {
        return Double.TYPE;
    }
}

