/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.common.renderer;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.ShapeRenderer;
import prefuse.visual.VisualItem;

public class ShapeLabelRenderer
implements Renderer {
    private ShapeRenderer shapeRenderer = new ShapeRenderer();
    private LabelRenderer labelRenderer;
    private Map firstRun = new HashMap();

    public ShapeLabelRenderer() {
        this("label");
    }

    public ShapeLabelRenderer(String labelField) {
        this.labelRenderer = new LabelRenderer(labelField);
        this.labelRenderer.setHorizontalAlignment(1);
        this.labelRenderer.setHorizontalPadding(this.shapeRenderer.getBaseSize());
        this.labelRenderer.setRenderType(0);
    }

    public boolean locatePoint(Point2D point, VisualItem item) {
        return this.shapeRenderer.locatePoint(point, item) || this.labelRenderer.locatePoint(point, item);
    }

    public void render(Graphics2D graphics, VisualItem item) {
        boolean scaled = false;
        double scale = item.getVisualization().getDisplay(0).getScale();
        Font currentFont = item.getFont();
        String row = "" + item.getRow();
        if (!this.firstRun.containsKey(row)) {
            item.setFont(currentFont.deriveFont((float)((double)currentFont.getSize() * 1.11 / item.getSize())));
            this.firstRun.put(row, new Boolean(false));
        } else if (scale > 0.8) {
            scaled = true;
            item.setFont(currentFont.deriveFont((float)((double)(currentFont.getSize() * 1) / Math.pow(scale, 0.6))));
        }
        this.shapeRenderer.render(graphics, item);
        this.labelRenderer.render(graphics, item);
        if (scaled) {
            item.setFont(currentFont);
        }
    }

    public void setBounds(VisualItem item) {
        Shape shapeShape = this.shapeRenderer.getShape(item);
        Shape labelShape = this.labelRenderer.getShape(item);
        BasicStroke stroke = item.getStroke();
        Rectangle shapeBounds = shapeShape.getBounds();
        Rectangle labelBounds = labelShape.getBounds();
        double x = Math.min(shapeBounds.x, labelBounds.x);
        double y = Math.min(shapeBounds.y, labelBounds.y);
        double w = ((double)Math.max(shapeBounds.x + shapeBounds.width, labelBounds.x + labelBounds.width) - x - (double)(shapeBounds.width / 2)) * 2.0;
        double h = (double)Math.max(shapeBounds.y + shapeBounds.height, labelBounds.y + labelBounds.height) - y;
        if (stroke != null) {
            double d;
            double lw = stroke.getLineWidth();
            if (d > 1.0) {
                double lw2 = lw / 2.0;
                x -= lw2;
                y -= lw2;
                w += lw;
                h += lw;
            }
        }
        item.setBounds(x, y, w, h);
    }
}

