/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.graphview;

import edu.iu.nwb.visualization.prefuse.beta.common.AbstractVisualization;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Dictionary;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JForcePanel;
import prefuse.util.ui.JValueSlider;
import prefuse.visual.VisualItem;

public class ForceDirectedVisualization
extends AbstractVisualization {
    private ForceDirectedLayout layout;
    private GraphDistanceFilter filter;
    private int hops = 30;

    @Override
    protected Component arrangeComponents(final Display display, JComponent legend) {
        display.pan(350.0, 350.0);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        ForceSimulator fsim = this.layout.getForceSimulator();
        JForcePanel fpanel = new JForcePanel(fsim);
        final JValueSlider slider = new JValueSlider("Distance", 0, this.hops, this.hops);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ForceDirectedVisualization.this.filter.setDistance(slider.getValue().intValue());
                display.getVisualization().run("draw");
            }
        });
        slider.setBackground(Color.WHITE);
        slider.setPreferredSize(new Dimension(300, 30));
        slider.setMaximumSize(new Dimension(300, 30));
        Box cf = new Box(1);
        cf.add((Component)slider);
        cf.setBorder(BorderFactory.createTitledBorder("Connectivity Filter"));
        fpanel.add((Component)cf);
        fpanel.add(Box.createVerticalGlue());
        JSplitPane split = new JSplitPane();
        split.setLeftComponent((Component)display);
        split.setRightComponent((Component)fpanel);
        split.setOneTouchExpandable(true);
        split.setContinuousLayout(false);
        split.setDividerLocation(700);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)split, "Center");
        panel.add((Component)legend, "South");
        return panel;
    }

    @Override
    protected Action getInitialDrawActions(String everythingGroup, Visualization visualization, Dictionary parameters) {
        this.filter = new GraphDistanceFilter(everythingGroup, this.hops);
        TupleSet group = visualization.getGroup(String.valueOf(everythingGroup) + ".nodes");
        VisualItem tuple = (VisualItem)group.tuples().next();
        visualization.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)tuple);
        return this.filter;
    }

    @Override
    protected Action getLayoutActions(String everythingGroup, Visualization visualization, Dictionary parameters) {
        ActionList animate = new ActionList(-1L);
        this.layout = new ForceDirectedLayout(everythingGroup);
        animate.add((Action)this.layout);
        animate.add((Action)new RepaintAction());
        return animate;
    }

    @Override
    protected void setTitle(JFrame frame) {
        frame.setTitle("Force Directed with Annotation (prefuse beta)");
    }
}

