/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.graphview;

import edu.iu.nwb.visualization.prefuse.beta.common.PrefuseBetaVisualization;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Dictionary;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.SizeAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JForcePanel;
import prefuse.util.ui.JValueSlider;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphViewVisualization
extends JPanel
implements PrefuseBetaVisualization {
    private static final long serialVersionUID = 1L;
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    private Visualization m_vis;
    public Graph visualGraph;
    private VisualGraph vg;

    public GraphViewVisualization(Graph g, String label) {
        this.m_vis = new Visualization();
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)tr));
        this.setGraph(g, label);
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                int i = 0;
                while (i < rem.length) {
                    ((VisualItem)rem[i]).setFixed(false);
                    ++i;
                }
                i = 0;
                while (i < add.length) {
                    ((VisualItem)add[i]).setFixed(false);
                    ((VisualItem)add[i]).setFixed(true);
                    ++i;
                }
                if (ts.getTupleCount() == 0) {
                    ts.addTuple(rem[0]);
                    ((VisualItem)rem[0]).setFixed(false);
                }
                GraphViewVisualization.this.m_vis.run("draw");
            }
        });
        SizeAction sizeAction = new SizeAction(){

            public double getSize(VisualItem item) {
                double scale = this.m_vis.getDisplay(0).getScale();
                if (scale <= 1.0) {
                    return 1.0;
                }
                return 1.0 / scale;
            }
        };
        this.m_vis.putAction("size", (Action)sizeAction);
        int hops = 30;
        final GraphDistanceFilter filter = new GraphDistanceFilter(graph, hops);
        ColorAction fill = new ColorAction(nodes, VisualItem.FILLCOLOR, ColorLib.rgb((int)200, (int)200, (int)255));
        fill.add(VisualItem.FIXED, ColorLib.rgb((int)255, (int)100, (int)100));
        fill.add(VisualItem.HIGHLIGHT, ColorLib.rgb((int)255, (int)200, (int)125));
        ActionList draw = new ActionList();
        draw.add((Action)filter);
        draw.add((Action)fill);
        draw.add((Action)new ColorAction(nodes, VisualItem.STROKECOLOR, 0));
        draw.add((Action)new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0)));
        draw.add((Action)new ColorAction(edges, VisualItem.FILLCOLOR, ColorLib.gray((int)200)));
        draw.add((Action)new ColorAction(edges, VisualItem.STROKECOLOR, ColorLib.gray((int)200)));
        ActionList animate = new ActionList(-1L);
        animate.add((Action)new ForceDirectedLayout(graph));
        animate.add((Action)fill);
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.m_vis.putAction("layout", (Action)animate);
        this.m_vis.runAfter("draw", "layout");
        Display display = new Display(this.m_vis);
        display.setSize(700, 700);
        display.pan(350.0, 350.0);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl(){

            public void mouseDragged(MouseEvent event) {
                GraphViewVisualization.this.m_vis.run("size");
                super.mouseDragged(event);
            }
        });
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new ZoomToFitControl(){

            public void mouseClicked(MouseEvent event) {
                GraphViewVisualization.this.m_vis.run("size");
                super.mouseClicked(event);
            }
        });
        display.addControlListener((Control)new NeighborHighlightControl());
        ForceSimulator fsim = ((ForceDirectedLayout)animate.get(0)).getForceSimulator();
        JForcePanel fpanel = new JForcePanel(fsim);
        final JValueSlider slider = new JValueSlider("Distance", 0, hops, hops);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                filter.setDistance(slider.getValue().intValue());
                GraphViewVisualization.this.m_vis.run("draw");
            }
        });
        slider.setBackground(Color.WHITE);
        slider.setPreferredSize(new Dimension(300, 30));
        slider.setMaximumSize(new Dimension(300, 30));
        Box cf = new Box(1);
        cf.add((Component)slider);
        cf.setBorder(BorderFactory.createTitledBorder("Connectivity Filter"));
        fpanel.add((Component)cf);
        fpanel.add(Box.createVerticalGlue());
        JSplitPane split = new JSplitPane();
        split.setLeftComponent((Component)display);
        split.setRightComponent((Component)fpanel);
        split.setOneTouchExpandable(true);
        split.setContinuousLayout(false);
        split.setDividerLocation(700);
        this.m_vis.run("draw");
        this.visualGraph = this.vg;
        this.add(split);
    }

    public GraphViewVisualization() {
    }

    public void setGraph(Graph g, String label) {
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup(graph);
        this.vg = this.m_vis.addGraph(graph, g);
        this.m_vis.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        VisualItem f = (VisualItem)this.vg.getNode(0);
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)f);
        f.setFixed(false);
    }

    @Override
    public Graph create(Graph graph, Dictionary parameters) {
        UILib.setPlatformLookAndFeel();
        String label = (String)parameters.get("label");
        JFrame frame = this.demo(graph, label);
        frame.setDefaultCloseOperation(2);
        return null;
    }

    public JFrame demo(Graph g, String label) {
        final GraphViewVisualization view = new GraphViewVisualization(g, label);
        this.visualGraph = view.visualGraph;
        JFrame frame = new JFrame("p r e f u s e  |  g r a p h v i e w");
        frame.setContentPane(view);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                view.m_vis.run("layout");
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                view.m_vis.cancel("layout");
            }
        });
        return frame;
    }
}

