/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.radialgraph;

import edu.iu.nwb.visualization.prefuse.beta.common.AbstractVisualization;
import edu.iu.nwb.visualization.prefuse.beta.common.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.GroupAction;
import prefuse.action.RepaintAction;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.FocusControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ui.JFastLabel;
import prefuse.visual.VisualItem;

public class RadialVisualization
extends AbstractVisualization {
    private String linear = "linear";

    @Override
    protected Component arrangeComponents(Display display, JComponent legend) {
        display.getVisualization().alwaysRunAfter("retree", "layout");
        display.addControlListener((Control)new FocusControl(1, "retree"));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(Constants.TITLE_FONT);
        display.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString("label")) {
                    title.setText(item.getString("label"));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(3));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)display, "Center");
        panel.add((Component)box, "South");
        JPanel overall = new JPanel(new BorderLayout());
        overall.add((Component)panel, "Center");
        overall.add((Component)legend, "South");
        return overall;
    }

    @Override
    protected void setTitle(JFrame frame) {
        frame.setTitle("Radial Tree/Graph with Annotation (prefuse beta)");
    }

    @Override
    protected Action getInitialDrawActions(String everythingGroup, Visualization visualization, Dictionary parameters) {
        ActionList retree = new ActionList();
        retree.add((Action)new TreeRootAction(everythingGroup));
        retree.add((Action)new RadialTreeLayout(everythingGroup));
        retree.add((Action)new CollapsedSubtreeLayout(everythingGroup));
        return retree;
    }

    @Override
    protected Action getLayoutActions(String everythingGroup, final Visualization visualization, Dictionary parameters) {
        ActionList retree = new ActionList();
        retree.add((Action)new TreeRootAction(everythingGroup));
        retree.add((Action)new RadialTreeLayout(everythingGroup));
        retree.add((Action)new CollapsedSubtreeLayout(everythingGroup));
        visualization.putAction("retree", (Action)retree);
        ActionList actions = new ActionList(1250L);
        actions.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        actions.add((Action)new QualityControlAnimator());
        actions.add((Action)new VisibilityAnimator(everythingGroup));
        actions.add((Action)new PolarLocationAnimator(String.valueOf(everythingGroup) + ".nodes", this.linear));
        actions.add((Action)new RepaintAction());
        visualization.addFocusGroup(this.linear, (TupleSet)new DefaultTupleSet());
        visualization.getGroup(Visualization.FOCUS_ITEMS).addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TupleSet linearInterp = visualization.getGroup(RadialVisualization.this.linear);
                if (add.length < 1) {
                    return;
                }
                linearInterp.clear();
                Node n = (Node)add[0];
                while (n != null) {
                    linearInterp.addTuple((Tuple)n);
                    n = n.getParent();
                }
            }
        });
        return actions;
    }

    public static class TreeRootAction
    extends GroupAction {
        public TreeRootAction(String graphGroup) {
            super(graphGroup);
        }

        public void run(double frac) {
            TupleSet focus = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
            if (focus == null || focus.getTupleCount() == 0) {
                return;
            }
            Graph g = (Graph)this.m_vis.getGroup(this.m_group);
            Node f = null;
            while (!g.containsTuple((Tuple)(f = (Node)focus.tuples().next()))) {
                f = null;
            }
            if (f == null) {
                return;
            }
            g.getSpanningTree(f);
        }
    }
}

