/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.specified;

import edu.iu.nwb.visualization.prefuse.beta.common.PrefuseBetaVisualization;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Dictionary;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.SizeAction;
import prefuse.action.layout.SpecifiedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractPredicate;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class SpecifiedVisualization
implements PrefuseBetaVisualization {
    private static final long serialVersionUID = 1L;
    public static final int LAYOUT_ANIMATION_DURATION_IN_MS = 1500;
    public static final int NUMBER_OF_CLICKS_FOR_FOCUS = 1;
    public static final Color DISPLAY_BACKGROUND_COLOR = Color.WHITE;
    public static final Color DISPLAY_FOREGROUND_COLOR = Color.GRAY;
    public static final int IU_CRIMSON;
    public static final int NODE_FILL_COLOR;
    public static final int EDGE_STROKE_COLOR;
    public static final int EDGE_FILL_COLOR;
    public static final int NODE_TEXT_COLOR;
    public static final int NODE_STROKE_COLOR;
    public static final int HIGHLIGHT_COLOR;
    public static final String FRAME_TITLE = "Pre-defined Positions (prefuse beta)";
    public static final String LAYOUT = "layout";
    public static final String DRAW = "draw";
    public static final String SIZE = "size";
    public static final String GRAPH = "graph";
    public static final String NODES = "graph.nodes";
    public static final String EDGES = "graph.edges";
    protected static final double NODE_SIZE_MAXIMUM = 0.5;
    public static final int NODE_LABEL_ROUNDED_ARC_WIDTH = 8;
    public static final int NODE_LABEL_ROUNDED_ARC_HEIGHT = 8;
    public static final int DEFAULT_DISPLAY_HEIGHT = 700;
    public static final int DEFAULT_DISPLAY_WIDTH = 900;
    private JPanel panel;
    private Visualization visualization;

    static {
        NODE_FILL_COLOR = IU_CRIMSON = ColorLib.rgb((int)125, (int)17, (int)12);
        EDGE_STROKE_COLOR = ColorLib.gray((int)200);
        EDGE_FILL_COLOR = ColorLib.gray((int)200);
        NODE_TEXT_COLOR = ColorLib.gray((int)255);
        NODE_STROKE_COLOR = ColorLib.gray((int)0);
        HIGHLIGHT_COLOR = ColorLib.rgb((int)255, (int)200, (int)125);
    }

    public SpecifiedVisualization() {
        this.panel = new JPanel();
    }

    public SpecifiedVisualization(Graph graph, String label, Dictionary parameters) {
        this.visualization = this.createVisualization(graph, parameters);
        Display display = SpecifiedVisualization.createInteractiveDisplay(this.visualization);
        this.panel = this.createPanel(display);
        this.panel.add((Component)display);
        this.visualization.run(DRAW);
    }

    @Override
    public Graph create(Graph graph, Dictionary parameters) {
        UILib.setPlatformLookAndFeel();
        String label = (String)parameters.get("label");
        JFrame frame = SpecifiedVisualization.createFrame(graph, label, parameters);
        frame.setDefaultCloseOperation(2);
        return null;
    }

    private Visualization createVisualization(Graph graph, Dictionary parameters) {
        Visualization visualization = new Visualization();
        LabelRenderer labelRenderer = new LabelRenderer();
        labelRenderer.setRoundedCorner(8, 8);
        visualization.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)labelRenderer));
        this.addScaledDoubleColumns(graph, parameters);
        visualization.removeGroup(GRAPH);
        visualization.addGraph(GRAPH, graph);
        this.setGroupInteractivity(visualization, EDGES, false);
        visualization.putAction(SIZE, (Action)this.createSizeAction());
        ColorAction fill = new ColorAction(NODES, VisualItem.FILLCOLOR, NODE_FILL_COLOR);
        fill.add(VisualItem.HIGHLIGHT, HIGHLIGHT_COLOR);
        visualization.putAction(DRAW, (Action)this.createDrawAction(fill));
        visualization.putAction(LAYOUT, (Action)this.createLayoutAction(fill));
        visualization.run(LAYOUT);
        visualization.runAfter(DRAW, SIZE);
        return visualization;
    }

    private static JFrame createFrame(Graph graph, String label, Dictionary parameters) {
        SpecifiedVisualization view = new SpecifiedVisualization(graph, label, parameters);
        JFrame frame = new JFrame(FRAME_TITLE);
        frame.setContentPane(view.getPanel());
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SpecifiedVisualization.this.visualization.run(SpecifiedVisualization.LAYOUT);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SpecifiedVisualization.this.visualization.cancel(SpecifiedVisualization.LAYOUT);
            }
        });
        return frame;
    }

    private JPanel createPanel(final Display display) {
        final JPanel panel = new JPanel();
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                display.setBounds(new Rectangle(e.getComponent().getSize()));
                panel.invalidate();
            }
        });
        return panel;
    }

    private static Display createInteractiveDisplay(Visualization visualization) {
        Display display = new Display(visualization);
        display.setSize(900, 700);
        display.pan(450.0, 350.0);
        display.setForeground(DISPLAY_FOREGROUND_COLOR);
        display.setBackground(DISPLAY_BACKGROUND_COLOR);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new ZoomToFitControl(NODES));
        display.addControlListener((Control)new NeighborHighlightControl());
        return display;
    }

    private ActionList createLayoutAction(ColorAction fill) {
        ActionList layoutActions = new ActionList(1500L);
        layoutActions.add((Action)new SpecifiedLayout(GRAPH, "_specified_x", "_specified_y"));
        layoutActions.add((Action)fill);
        layoutActions.add((Action)new RepaintAction());
        return layoutActions;
    }

    private ActionList createDrawAction(ColorAction fill) {
        ActionList drawActions = new ActionList();
        drawActions.add((Action)fill);
        drawActions.add((Action)new ColorAction(NODES, VisualItem.STROKECOLOR, NODE_STROKE_COLOR));
        drawActions.add((Action)new ColorAction(NODES, VisualItem.TEXTCOLOR, NODE_TEXT_COLOR));
        drawActions.add((Action)new ColorAction(EDGES, VisualItem.FILLCOLOR, EDGE_FILL_COLOR));
        drawActions.add((Action)new ColorAction(EDGES, VisualItem.STROKECOLOR, EDGE_STROKE_COLOR));
        return drawActions;
    }

    private SizeAction createSizeAction() {
        SizeAction sizeAction = new SizeAction(){

            public double getSize(VisualItem item) {
                double scale = this.m_vis.getDisplay(0).getScale();
                if (scale <= 1.0) {
                    return 0.5;
                }
                return 0.5 / scale;
            }
        };
        return sizeAction;
    }

    private void addScaledDoubleColumns(Graph graph, Dictionary parameters) {
        String xLabel = (String)parameters.get("x");
        String yLabel = (String)parameters.get("y");
        class DoubleParsingExpression
        extends ColumnExpression {
            public static final int DRL_TO_VISUAL_SCALE_FACTOR = 20;

            DoubleParsingExpression(String column) {
                super(column);
            }

            public double getDouble(Tuple t) {
                double drlValue = Double.NaN;
                drlValue = super.getType(t.getSchema()) == Double.TYPE ? super.getDouble(t) : Double.parseDouble((String)super.get(t));
                double visualValue = 20.0 * drlValue;
                return visualValue;
            }

            public Class getType(Schema s) {
                return Double.TYPE;
            }
        }
        graph.addColumn("_specified_x", (Expression)new DoubleParsingExpression(xLabel));
        graph.addColumn("_specified_y", (Expression)new DoubleParsingExpression(yLabel));
    }

    private void setGroupInteractivity(Visualization visualization, String groupIdentifier, boolean isInteractive) {
        visualization.setValue(groupIdentifier, (Predicate)new ConstantTruePredicate(), VisualItem.INTERACTIVE, (Object)new Boolean(isInteractive));
    }

    private Container getPanel() {
        return this.panel;
    }

    public static final class ConstantTruePredicate
    extends AbstractPredicate {
        public Object get(Tuple tuple) {
            return Boolean.TRUE;
        }

        public boolean getBoolean(Tuple tuple) {
            return true;
        }
    }
}

