/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.prefuse.beta.treemap;

import edu.iu.nwb.visualization.prefuse.beta.common.PrefuseBetaVisualization;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Dictionary;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.SquarifiedTreeMapLayout;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Tree;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.tuple.TupleSet;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.FontLib;
import prefuse.util.PrefuseLib;
import prefuse.util.UpdateListener;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.DecoratorItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTree;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class TreeMapVisualization
extends Display
implements PrefuseBetaVisualization {
    private static final long serialVersionUID = 1L;
    public static final String TREE_CHI = "/chi-ontology.xml.gz";
    private static final Schema LABEL_SCHEMA = PrefuseLib.getVisualItemSchema();
    private static final String tree = "tree";
    private static final String treeNodes = "tree.nodes";
    private static final String treeEdges = "tree.edges";
    private static final String labels = "labels";
    private SearchQueryBinding searchQ;

    static {
        LABEL_SCHEMA.setDefault(VisualItem.INTERACTIVE, false);
        LABEL_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)200));
        LABEL_SCHEMA.setDefault(VisualItem.FONT, (Object)FontLib.getFont((String)"Tahoma", (double)16.0));
    }

    public TreeMapVisualization(Tree t, String label) {
        super(new Visualization());
        VisualTree vt = this.m_vis.addTree(tree, t);
        this.m_vis.setVisible(treeEdges, null, false);
        Predicate noLeaf = (Predicate)ExpressionParser.parse((String)"childcount()>0");
        this.m_vis.setInteractive(treeNodes, noLeaf, false);
        Predicate labelP = (Predicate)ExpressionParser.parse((String)"treedepth()=1");
        this.m_vis.addDecorators(labels, treeNodes, labelP, LABEL_SCHEMA);
        DefaultRendererFactory rf = new DefaultRendererFactory();
        rf.add((Predicate)new InGroupPredicate(treeNodes), (Renderer)new NodeRenderer());
        rf.add((Predicate)new InGroupPredicate(labels), (Renderer)new LabelRenderer(label));
        this.m_vis.setRendererFactory((RendererFactory)rf);
        final BorderColorAction borderColor = new BorderColorAction(treeNodes);
        FillColorAction fillColor = new FillColorAction(treeNodes);
        ActionList colors = new ActionList();
        colors.add((Action)fillColor);
        colors.add((Action)borderColor);
        this.m_vis.putAction("colors", (Action)colors);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator(treeNodes));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        ActionList layout = new ActionList();
        layout.add((Action)new SquarifiedTreeMapLayout(tree));
        layout.add((Action)new LabelLayout(labels));
        layout.add((Action)colors);
        layout.add((Action)new RepaintAction());
        this.m_vis.putAction("layout", (Action)layout);
        this.setSize(700, 600);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                item.setStrokeColor(borderColor.getColor(item));
                item.getVisualization().repaint();
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                item.setStrokeColor(item.getEndStrokeColor());
                item.getVisualization().repaint();
            }
        });
        this.searchQ = new SearchQueryBinding((TupleSet)vt.getNodeTable(), label);
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)this.searchQ.getSearchSet());
        this.searchQ.getPredicate().addExpressionListener((ExpressionListener)new UpdateListener(){

            public void update(Object src) {
                TreeMapVisualization.this.m_vis.cancel("animatePaint");
                TreeMapVisualization.this.m_vis.run("colors");
                TreeMapVisualization.this.m_vis.run("animatePaint");
            }
        });
        this.m_vis.run("layout");
    }

    public TreeMapVisualization() {
    }

    public SearchQueryBinding getSearchQuery() {
        return this.searchQ;
    }

    @Override
    public Graph create(Graph graph, Dictionary parameters) {
        UILib.setPlatformLookAndFeel();
        String label = (String)parameters.get("label");
        JComponent treemap = this.demo((Tree)graph, label);
        JFrame frame = new JFrame("Tree Map (prefuse beta)");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(treemap);
        frame.pack();
        frame.setVisible(true);
        return null;
    }

    public JComponent demo(Tree t, final String label) {
        TreeMapVisualization treemap = new TreeMapVisualization(t, label);
        JSearchPanel search = treemap.getSearchQuery().createSearchPanel();
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        treemap.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                title.setText(item.getString(label));
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = UILib.getBox((Component[])new Component[]{title, search}, (boolean)true, (int)10, (int)3, (int)0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)treemap), "Center");
        panel.add((Component)box, "South");
        UILib.setColor((Component)panel, (Color)Color.BLACK, (Color)Color.GRAY);
        return panel;
    }

    public static class BorderColorAction
    extends ColorAction {
        public BorderColorAction(String group) {
            super(group, VisualItem.STROKECOLOR);
        }

        public int getColor(VisualItem item) {
            NodeItem nitem = (NodeItem)item;
            if (nitem.isHover()) {
                return ColorLib.rgb((int)99, (int)130, (int)191);
            }
            int depth = nitem.getDepth();
            if (depth < 2) {
                return ColorLib.gray((int)100);
            }
            if (depth < 4) {
                return ColorLib.gray((int)75);
            }
            return ColorLib.gray((int)50);
        }
    }

    public static class FillColorAction
    extends ColorAction {
        private ColorMap cmap = new ColorMap(ColorLib.getInterpolatedPalette((int)10, (int)ColorLib.rgb((int)85, (int)85, (int)85), (int)ColorLib.rgb((int)0, (int)0, (int)0)), 0.0, 9.0);

        public FillColorAction(String group) {
            super(group, VisualItem.FILLCOLOR);
        }

        public int getColor(VisualItem item) {
            if (item instanceof NodeItem) {
                NodeItem nitem = (NodeItem)item;
                if (nitem.getChildCount() > 0) {
                    return 0;
                }
                if (this.m_vis.isInGroup(item, Visualization.SEARCH_ITEMS)) {
                    return ColorLib.rgb((int)191, (int)99, (int)130);
                }
                return this.cmap.getColor((double)nitem.getDepth());
            }
            return this.cmap.getColor(0.0);
        }
    }

    public static class LabelLayout
    extends Layout {
        public LabelLayout(String group) {
            super(group);
        }

        public void run(double frac) {
            Iterator iter = this.m_vis.items(this.m_group);
            while (iter.hasNext()) {
                DecoratorItem item = (DecoratorItem)iter.next();
                VisualItem node = item.getDecoratedItem();
                Rectangle2D bounds = node.getBounds();
                this.setX((VisualItem)item, null, bounds.getCenterX());
                this.setY((VisualItem)item, null, bounds.getCenterY());
            }
        }
    }

    public static class NodeRenderer
    extends AbstractShapeRenderer {
        private Rectangle2D m_bounds = new Rectangle2D.Double();

        public NodeRenderer() {
            this.m_manageBounds = false;
        }

        protected Shape getRawShape(VisualItem item) {
            this.m_bounds.setRect(item.getBounds());
            return this.m_bounds;
        }
    }
}

