/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.radialgraph;

import edu.berkeley.guir.prefuse.graph.Graph;
import edu.iu.nwb.visualization.radialgraph.RadialGraphVisualization;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class RadialGraph
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] dm, Dictionary parameters, CIShellContext context) {
        return new RadialGraphAlg(dm, parameters, context);
    }

    private class RadialGraphAlg
    implements Algorithm {
        Data[] dm;
        Dictionary parameters;
        CIShellContext ciContext;
        LogService log;

        public RadialGraphAlg(Data[] dm, Dictionary parameters, CIShellContext ciContext) {
            this.dm = dm;
            this.parameters = parameters;
            this.ciContext = ciContext;
            this.log = (LogService)ciContext.getService(LogService.class.getName());
        }

        public Data[] execute() {
            this.log.log(3, "");
            this.log.log(3, "Note that the radial graph layout will ignore all but the first weak component in a graph.");
            this.log.log(3, "Nodes belonging to additional weak components will be placed in the upper-left-hand corner.");
            this.log.log(3, "Because of this, the Radial Graph layout is not recommended for graphs with more than one weak component");
            Graph graph = (Graph)this.dm[0].getData();
            RadialGraphVisualization rgv = new RadialGraphVisualization();
            rgv.setInput(graph);
            rgv.show();
            return null;
        }
    }
}

