/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.radialgraph;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.action.RepaintAction;
import edu.berkeley.guir.prefuse.action.animate.ColorAnimator;
import edu.berkeley.guir.prefuse.action.animate.PolarLocationAnimator;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import edu.berkeley.guir.prefuse.action.filter.TreeFilter;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.activity.Pacer;
import edu.berkeley.guir.prefuse.activity.SlowInSlowOutPacer;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import edu.berkeley.guir.prefuse.render.DefaultEdgeRenderer;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefuse.render.TextItemRenderer;
import edu.berkeley.guir.prefuse.util.ColorLib;
import edu.berkeley.guir.prefuse.util.StringAbbreviator;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.FocusControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import edu.berkeley.guir.prefusex.layout.RadialTreeLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Paint;
import javax.swing.JFrame;

public class RadialGraphVisualization {
    public static final String nameField = "label";
    private ItemRegistry registry;
    private Graph graph;
    private Display display;
    private ActionList layout;
    private ActionList update;
    private ActionList animate;
    private ActionList filter;
    private JFrame frame;

    public void setInput(Graph graph) {
        this.graph = graph;
    }

    public void show() {
        try {
            this.registry = new ItemRegistry(this.graph);
            this.display = new Display();
            this.initializeRenderers();
            this.initializeActionList();
            this.initializeDisplay();
            this.registry.getDefaultFocusSet().addFocusListener(new FocusListener(){

                public void focusChanged(FocusEvent e) {
                    Node node;
                    if (RadialGraphVisualization.this.update.isScheduled()) {
                        RadialGraphVisualization.this.update.cancel();
                    }
                    if ((node = (Node)e.getFirstAdded()) != null) {
                        NodeItem item = RadialGraphVisualization.this.registry.getNodeItem(node);
                        Tree t = GraphLib.breadthFirstTree((TreeNode)item);
                        RadialGraphVisualization.this.registry.setFilteredGraph((Graph)t);
                        RadialGraphVisualization.this.layout.runNow();
                        RadialGraphVisualization.this.animate.runNow();
                    }
                }
            });
            this.frame = new JFrame("Radial Tree/Graph (prefuse alpha)");
            this.frame.setDefaultCloseOperation(2);
            this.frame.getContentPane().add((Component)this.display, "Center");
            this.frame.pack();
            this.frame.setVisible(true);
            this.filter.runNow();
            this.layout.runNow();
            this.animate.runNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeRenderers() {
        TextItemRenderer nodeRenderer = new TextItemRenderer(){
            private int maxWidth = 175;
            private StringAbbreviator abbrev = new StringAbbreviator(null, null);

            protected String getText(VisualItem item) {
                String s = item.getAttribute(this.m_labelName);
                Font font = item.getFont();
                if (font == null) {
                    font = this.m_font;
                }
                FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(font);
                if (s != null && fm.stringWidth(s) > this.maxWidth) {
                    s = this.abbrev.abbreviate(s, 0, fm, this.maxWidth);
                }
                return s;
            }
        };
        DefaultEdgeRenderer edgeRenderer = new DefaultEdgeRenderer(){

            protected int getLineWidth(VisualItem item) {
                String w = item.getAttribute("weight");
                if (w != null) {
                    try {
                        return Integer.parseInt(w);
                    }
                    catch (Exception exception) {}
                }
                return this.m_width;
            }
        };
        Renderer aggrRenderer = null;
        ((TextItemRenderer)nodeRenderer).setRoundedCorner(8, 8);
        this.registry.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, aggrRenderer));
    }

    private void initializeActionList() {
        this.filter = new ActionList(this.registry);
        this.filter.add((Action)new TreeFilter());
        this.layout = new ActionList(this.registry);
        this.layout.add((Action)new RadialTreeLayout());
        this.layout.add((Action)new DemoColorFunction(3));
        this.update = new ActionList(this.registry);
        this.update.add((Action)new DemoColorFunction(3));
        this.update.add((Action)new RepaintAction());
        this.animate = new ActionList(this.registry, 1500L, 20L);
        this.animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        this.animate.add((Action)new PolarLocationAnimator());
        this.animate.add((Action)new ColorAnimator());
        this.animate.add((Action)new RepaintAction());
    }

    private void initializeDisplay() {
        this.display.setItemRegistry(this.registry);
        this.display.setSize(700, 700);
        this.display.setBackground(Color.WHITE);
        this.display.addControlListener((ControlListener)new FocusControl());
        this.display.addControlListener((ControlListener)new DragControl());
        this.display.addControlListener((ControlListener)new PanControl());
        this.display.addControlListener((ControlListener)new ZoomControl());
        this.display.addControlListener((ControlListener)new NeighborHighlightControl((Activity)this.update));
    }

    public class DemoColorFunction
    extends ColorFunction {
        private Color graphEdgeColor = Color.LIGHT_GRAY;
        private Color highlightColor = new Color(50, 50, 255);
        private Color[] nodeColors;
        private Color[] edgeColors;

        public DemoColorFunction(int thresh) {
            this.nodeColors = new Color[thresh];
            this.edgeColors = new Color[thresh];
            int i = 0;
            while (i < thresh) {
                double frac = (double)i / (double)thresh;
                this.nodeColors[i] = ColorLib.getIntermediateColor((Color)Color.RED, (Color)Color.BLACK, (double)frac);
                this.edgeColors[i] = ColorLib.getIntermediateColor((Color)Color.RED, (Color)Color.BLACK, (double)frac);
                ++i;
            }
        }

        public Paint getFillColor(VisualItem item) {
            if (item instanceof NodeItem) {
                return Color.WHITE;
            }
            if (item instanceof AggregateItem) {
                return Color.LIGHT_GRAY;
            }
            if (item instanceof EdgeItem) {
                return this.getColor(item);
            }
            return Color.BLACK;
        }

        public Paint getColor(VisualItem item) {
            if (item.isHighlighted()) {
                return this.highlightColor;
            }
            if (item instanceof NodeItem) {
                int d = ((NodeItem)item).getDepth();
                return this.nodeColors[Math.min(d, this.nodeColors.length - 1)];
            }
            if (item instanceof EdgeItem) {
                EdgeItem e = (EdgeItem)item;
                if (e.isTreeEdge()) {
                    int d1 = ((NodeItem)e.getFirstNode()).getDepth();
                    int d2 = ((NodeItem)e.getSecondNode()).getDepth();
                    int d = Math.max(d1, d2);
                    return this.edgeColors[Math.min(d, this.edgeColors.length - 1)];
                }
                return this.graphEdgeColor;
            }
            return Color.BLACK;
        }
    }
}

