/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell;

import edu.iu.nwb.visualization.roundrussell.RoundRussellAlgorithm;
import edu.iu.nwb.visualization.roundrussell.interpolation.InputRangeException;
import edu.iu.nwb.visualization.roundrussell.interpolation.Interpolator;
import edu.iu.nwb.visualization.roundrussell.interpolation.InterpolatorInversionException;
import edu.iu.nwb.visualization.roundrussell.legend.ColorLegend;
import edu.iu.nwb.visualization.roundrussell.legend.Legend;
import edu.iu.nwb.visualization.roundrussell.utility.Averager;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.framework.algorithm.AlgorithmExecutionException;

public class PostScriptOperations {
    private static URL postScriptHeaderFile = null;
    private static String NO_LEGEND_POSTSCRIPT_COMMENT = "% No legend possible due to \n% inappropriate node color attribute values.\n";

    public static void setPostScriptHeaderFile(URL postScriptHeaderFile) {
        PostScriptOperations.postScriptHeaderFile = postScriptHeaderFile;
    }

    public static String getPostScriptUtilityDefinitions() {
        StringTemplate definitionsTemplate = RoundRussellAlgorithm.group.getInstanceOf("utilityDefinitions");
        return definitionsTemplate.toString();
    }

    public static String getPostScriptHeaderContent() throws AlgorithmExecutionException {
        InputStream inStream = null;
        BufferedReader input = null;
        String psHeaderContentinString = "";
        try {
            try {
                String line;
                URLConnection connection = postScriptHeaderFile.openConnection();
                connection.setDoInput(true);
                inStream = connection.getInputStream();
                input = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                while ((line = input.readLine()) != null) {
                    psHeaderContentinString = psHeaderContentinString.concat(line).concat("\n");
                }
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return psHeaderContentinString;
    }

    public static String getColorLegendContent(Interpolator<Color> colorQuantityInterpolator, Range<Double> nodeColorValueRange, Range<Color> colorRange, String nodeColorColumnName) throws AlgorithmExecutionException, InputRangeException, InterpolatorInversionException {
        Color colorMidrange = Averager.mean(colorRange.getMin(), colorRange.getMax());
        double colorMidrangePreimage = colorQuantityInterpolator.invert(colorMidrange);
        double colorGradientLowerLeftX = 306.0;
        double colorGradientLowerLeftY = 108.0;
        double colorGradientWidth = 122.4;
        double colorGradientHeight = 10.0;
        String colorTypeLabel = "Node Color";
        String colorScaling = "";
        String colorQuantityAttribute = "based on " + nodeColorColumnName.toUpperCase() + " attribute";
        try {
            ColorLegend colorGradient = new ColorLegend(nodeColorValueRange, colorScaling, colorMidrangePreimage, colorRange, colorTypeLabel, colorQuantityAttribute, colorGradientLowerLeftX, colorGradientLowerLeftY, colorGradientWidth, colorGradientHeight);
            Legend legend = new Legend();
            legend.add(colorGradient);
            return legend.toPostScript();
        }
        catch (AlgorithmExecutionException algorithmExecutionException) {
            return NO_LEGEND_POSTSCRIPT_COMMENT;
        }
    }
}

