/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell;

import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.nwb.visualization.roundrussell.PostScriptOperations;
import edu.iu.nwb.visualization.roundrussell.RoundRussellComputation;
import edu.iu.nwb.visualization.roundrussell.interpolation.InputRangeException;
import edu.iu.nwb.visualization.roundrussell.interpolation.InterpolatorInversionException;
import edu.iu.nwb.visualization.roundrussell.utility.Constants;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.osgi.service.log.LogService;

public class RoundRussellAlgorithm
implements Algorithm {
    public static final String OUTPUT_DATA_LABEL = "Circular Hierarchy Viz.ps";
    public static final String POSTSCRIPT_MIME_TYPE = "file:text/ps";
    public static final String WEIGHT_COLUMN_ID = "weightcolumn";
    public static final String STRENGTH_COLUMN_ID = "strengthcolumn";
    public static final String LEVEL0_COLUMN_ID = "level0_column";
    public static final String LEVEL1_COLUMN_ID = "level1_column";
    public static final String LEVEL2_COLUMN_ID = "level2_column";
    public static final String LEVEL3_COLUMN_ID = "level3_column";
    public static final String NODE_COLOR_COLUMN_ID = "nodecolorcolumn";
    public static final String NODE_COLOR_RANGE_ID = "nodecolorrange";
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private LogService logger;
    public static final String NO_LEVEL_COLUMN_NAME = "no_level_column";
    public static final String NO_STRENGTH_COLUMN_NAME = "no_strength_column";
    public static final String STRING_TEMPLATE_FILE_PATH = "/edu/iu/nwb/visualization/roundrussell/stringtemplates/group.st";
    public static StringTemplateGroup group = RoundRussellAlgorithm.loadTemplates();

    public RoundRussellAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inputData = (File)this.data[0].getData();
        int numberOfNodes = 0;
        try {
            numberOfNodes = this.countNodesInNWBFile(inputData);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.", (Throwable)e);
        }
        if (numberOfNodes > 0) {
            try {
                String edgeWeightColumnName = (String)this.parameters.get(WEIGHT_COLUMN_ID);
                String nodeStrengthColumnName = (String)this.parameters.get(STRENGTH_COLUMN_ID);
                boolean useStrength = true;
                if ("No Strength".equals(nodeStrengthColumnName)) {
                    useStrength = false;
                }
                String level0ColumnName = (String)this.parameters.get(LEVEL0_COLUMN_ID);
                String level1ColumnName = (String)this.parameters.get(LEVEL1_COLUMN_ID);
                String level2ColumnName = (String)this.parameters.get(LEVEL2_COLUMN_ID);
                String level3ColumnName = (String)this.parameters.get(LEVEL3_COLUMN_ID);
                String nodeColorColumnName = (String)this.parameters.get(NODE_COLOR_COLUMN_ID);
                boolean useNodeColor = true;
                if ("No Node Color".equals(nodeColorColumnName)) {
                    useNodeColor = false;
                }
                String nodecolorRangeIdentifier = (String)this.parameters.get(NODE_COLOR_RANGE_ID);
                Range<Color> nodeColorRange = Constants.COLOR_RANGES.get(nodecolorRangeIdentifier);
                int numberOfLevelsSpecified = 0;
                ArrayList<String> levelColumnNames = new ArrayList<String>();
                numberOfLevelsSpecified = this.setLevelColumnNames(level0ColumnName, level1ColumnName, level2ColumnName, level3ColumnName, numberOfLevelsSpecified, levelColumnNames);
                double betaCurvedValue = Double.parseDouble(this.parameters.get("betacolumn").toString());
                if (numberOfLevelsSpecified < 1) {
                    throw new AlgorithmExecutionException("At least 1 \"level\" column should be specified.");
                }
                NWBFileParser parser = new NWBFileParser(inputData);
                RoundRussellComputation russellRoundComputation = new RoundRussellComputation(numberOfNodes, useStrength, nodeStrengthColumnName, levelColumnNames, edgeWeightColumnName, useNodeColor, nodeColorColumnName, nodeColorRange, betaCurvedValue, this.logger);
                parser.parse((NWBFileParserHandler)russellRoundComputation);
                Data outputPSData = this.generateOutputPSFile(russellRoundComputation, nodeColorColumnName, nodeColorRange, nodecolorRangeIdentifier, this.logger);
                return new Data[]{outputPSData};
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException("NWB File'" + inputData.getAbsolutePath() + "' not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (ParsingException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
        return this.data;
    }

    private int setLevelColumnNames(String level0ColumnName, String level1ColumnName, String level2ColumnName, String level3ColumnName, int numberOfLevelsSpecified, List<String> levelColumnNames) {
        if ("No Level".equalsIgnoreCase(level0ColumnName)) {
            levelColumnNames.add(NO_LEVEL_COLUMN_NAME);
        } else {
            levelColumnNames.add(level0ColumnName);
            ++numberOfLevelsSpecified;
        }
        if ("No Level".equalsIgnoreCase(level1ColumnName)) {
            levelColumnNames.add(NO_LEVEL_COLUMN_NAME);
        } else {
            levelColumnNames.add(level1ColumnName);
            ++numberOfLevelsSpecified;
        }
        if ("No Level".equalsIgnoreCase(level2ColumnName)) {
            levelColumnNames.add(NO_LEVEL_COLUMN_NAME);
        } else {
            levelColumnNames.add(level2ColumnName);
            ++numberOfLevelsSpecified;
        }
        if ("No Level".equalsIgnoreCase(level3ColumnName)) {
            levelColumnNames.add(NO_LEVEL_COLUMN_NAME);
        } else {
            levelColumnNames.add(level3ColumnName);
            ++numberOfLevelsSpecified;
        }
        return numberOfLevelsSpecified;
    }

    private Data generateOutputPSFile(RoundRussellComputation russellRoundComputation, String nodeColorColumnName, Range<Color> nodeColorRange, String nodecolorRangeIdentifier, LogService logger) throws IOException {
        File outputPSFile = File.createTempFile("ps-", ".ps");
        FileWriter out = null;
        try {
            out = new FileWriter(outputPSFile);
            out.write(PostScriptOperations.getPostScriptHeaderContent());
            out.write("\n");
            out.write(PostScriptOperations.getPostScriptUtilityDefinitions());
            out.write("\n");
            out.write(russellRoundComputation.psFileContent.toString());
            out.write("\n");
            if (!"No Node Color".equalsIgnoreCase(nodeColorColumnName) && russellRoundComputation.nodeColorInterpolator != null) {
                out.write(PostScriptOperations.getColorLegendContent(russellRoundComputation.nodeColorInterpolator, russellRoundComputation.getNodeColorValueRange(), nodeColorRange, nodeColorColumnName));
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e) {
            logger.log(1, e.getMessage(), (Throwable)e);
        }
        catch (AlgorithmExecutionException e) {
            logger.log(1, e.getMessage(), (Throwable)e);
        }
        catch (InputRangeException e) {
            logger.log(1, e.getMessage(), (Throwable)e);
        }
        catch (InterpolatorInversionException e) {
            logger.log(1, e.getMessage(), (Throwable)e);
        }
        BasicData outputPSData = new BasicData((Object)outputPSFile, POSTSCRIPT_MIME_TYPE);
        outputPSData.getMetadata().put("Label", "CircularHierarchy_" + FileUtilities.extractFileName((String)this.data[0].getMetadata().get("Label").toString()) + ".ps");
        outputPSData.getMetadata().put("Type", "Vector Image");
        outputPSData.getMetadata().put("Parent", this.data[0]);
        return outputPSData;
    }

    private static StringTemplateGroup loadTemplates() {
        return new StringTemplateGroup((Reader)new InputStreamReader(RoundRussellAlgorithm.class.getResourceAsStream(STRING_TEMPLATE_FILE_PATH)));
    }

    private int countNodesInNWBFile(File inNWBFile) throws ParsingException, AlgorithmExecutionException {
        ValidateNWBFile validateParser = new ValidateNWBFile();
        try {
            validateParser.validateNWBFormat(inNWBFile);
            return validateParser.getTotalNumOfNodes();
        }
        catch (Exception e) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided. \n" + e.getMessage());
        }
    }
}

