/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell;

import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.nwb.visualization.roundrussell.PostScriptOperations;
import edu.iu.nwb.visualization.roundrussell.RoundRussellAlgorithm;
import edu.iu.nwb.visualization.roundrussell.utility.Constants;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ArrayListUtilities;
import org.cishell.utilities.MapUtilities;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.ObjectClassDefinition;

public class RoundRussellAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String NO_EDGE_WEIGHT_IDENTIFIER = "Unweighted";
    public static final String NO_STRENGTH_IDENTIFIER = "No Strength";
    public static final String NO_COLOR_IDENTIFIER = "No Node Color";
    public static final String NO_LEVEL_IDENTIFIER = "No Level";
    public static final Collection<String> NODE_KEYS_TO_IGNORE = Collections.unmodifiableList(Arrays.asList("id"));
    public static final Collection<String> NODE_STRENGTH_KEYS_TO_ADD_TO_FRONT = Collections.unmodifiableList(Arrays.asList("No Strength"));
    public static final Collection<String> NODE_C0LOR_KEYS_TO_ADD_TO_FRONT = Collections.unmodifiableList(Arrays.asList("No Node Color"));
    public static final Collection<String> NODE_LEVEL_KEYS_TO_ADD_TO_FRONT = Collections.unmodifiableList(Arrays.asList("No Level"));
    public static final Collection<String> EGGE_KEYS_TO_IGNORE = Collections.unmodifiableList(Arrays.asList("source", "target"));
    public static final Collection<String> EDGE_KEYS_TO_ADD_TO_FRONT = Collections.unmodifiableList(Arrays.asList("Unweighted"));
    private static URL postScriptHeaderPath;
    private static final String postScriptHeaderFilePath = "postScriptHeader.ps";

    protected void activate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        postScriptHeaderPath = bundleContext.getBundle().getResource(postScriptHeaderFilePath);
        PostScriptOperations.setPostScriptHeaderFile(postScriptHeaderPath);
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        return new RoundRussellAlgorithm(data, parameters, context);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata metaDataHandler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)metaDataHandler);
        }
        catch (IOException iOException) {
            return parameters;
        }
        catch (ParsingException parsingException) {
            return parameters;
        }
        Collection nodeStrengthAttribute = MapUtilities.getValidKeysOfTypesInMap((Map)metaDataHandler.getNodeSchema(), (Collection)NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES, NODE_KEYS_TO_IGNORE);
        nodeStrengthAttribute = ArrayListUtilities.unionCollections(NODE_STRENGTH_KEYS_TO_ADD_TO_FRONT, (Collection)nodeStrengthAttribute, null);
        Collection nodeColorAttribute = MapUtilities.getValidKeysOfTypesInMap((Map)metaDataHandler.getNodeSchema(), (Collection)NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES, NODE_KEYS_TO_IGNORE);
        nodeColorAttribute = ArrayListUtilities.unionCollections(NODE_C0LOR_KEYS_TO_ADD_TO_FRONT, (Collection)nodeColorAttribute, null);
        Collection nodeLevelAttribute = MapUtilities.getValidKeysOfTypesInMap((Map)metaDataHandler.getNodeSchema(), (Collection)NWBFileProperty.ALL_ATTRIBUTE_TYPES, NODE_KEYS_TO_IGNORE);
        nodeLevelAttribute = ArrayListUtilities.unionCollections(NODE_LEVEL_KEYS_TO_ADD_TO_FRONT, (Collection)nodeLevelAttribute, null);
        LinkedHashMap edgeSchema = metaDataHandler.getDirectedEdgeSchema() != null ? metaDataHandler.getDirectedEdgeSchema() : metaDataHandler.getUndirectedEdgeSchema();
        Collection edgeAttributes = MapUtilities.getValidKeysOfTypesInMap((Map)edgeSchema, (Collection)NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES, EGGE_KEYS_TO_IGNORE);
        edgeAttributes = ArrayListUtilities.unionCollections(EDGE_KEYS_TO_ADD_TO_FRONT, (Collection)edgeAttributes, null);
        DropdownMutator mutator = new DropdownMutator();
        mutator.add("strengthcolumn", nodeStrengthAttribute, this.getMatchedKey(nodeStrengthAttribute, "strength"));
        mutator.add("level0_column", nodeLevelAttribute, this.getDefaultLevelOption(nodeLevelAttribute, 0));
        mutator.add("level1_column", nodeLevelAttribute, this.getDefaultLevelOption(nodeLevelAttribute, 1));
        mutator.add("level2_column", nodeLevelAttribute, this.getDefaultLevelOption(nodeLevelAttribute, 2));
        mutator.add("level3_column", nodeLevelAttribute, this.getDefaultLevelOption(nodeLevelAttribute, 3));
        mutator.add("weightcolumn", edgeAttributes, this.getMatchedKey(edgeAttributes, "weight"));
        mutator.add("nodecolorcolumn", nodeColorAttribute, this.getMatchedKey(nodeColorAttribute, "color"));
        mutator.add("nodecolorrange", new ArrayList<String>(Constants.COLOR_RANGES.keySet()));
        return mutator.mutate(parameters);
    }

    private String getDefaultLevelOption(Collection<String> nodeLevelAttributes, int levelIndicator) {
        for (String nodeLevelAttribute : nodeLevelAttributes) {
            String lowerCaseNodeLevelAttributeName = nodeLevelAttribute.toLowerCase();
            if (!lowerCaseNodeLevelAttributeName.contains("level") || !lowerCaseNodeLevelAttributeName.contains(String.valueOf(levelIndicator))) continue;
            return nodeLevelAttribute;
        }
        return NO_LEVEL_IDENTIFIER;
    }

    private String getMatchedKey(Collection<String> attributeNames, String suggestedPattern) {
        String lowerCaseSuggestedPattern = suggestedPattern.toLowerCase();
        for (String attributeName : attributeNames) {
            String lowerCaseAttributeName = attributeName.toLowerCase();
            if (!lowerCaseAttributeName.contains(lowerCaseSuggestedPattern)) continue;
            return attributeName;
        }
        return null;
    }
}

