/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell;

import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.visualization.roundrussell.interpolation.ColorInterpolator;
import edu.iu.nwb.visualization.roundrussell.interpolation.InputRangeException;
import edu.iu.nwb.visualization.roundrussell.interpolation.Interpolator;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.osgi.service.log.LogService;

public class RoundRussellComputation
implements NWBFileParserHandler {
    private static final Color DEFAULT_NODE_COLOR = new Color(203, 203, 203);
    private static final double RGB_NORMALIZING_VALUE = 255.0;
    private static final int IN_COMMUNITY_BOUND = 4;
    private static final double DEFAULT_EDGE_WEIGHT = 1.0;
    private static final double DEFAULT_NODE_STRENGTH = 1.0;
    private static final double DEFAULT_NODE_COLOR_VALUE = 1.0;
    public static final double CANVAS_RADIUS = 800.0;
    public Interpolator<Color> nodeColorInterpolator = null;
    public StringBuilder psFileContent = new StringBuilder();
    private String nodeStrengthColumnName;
    private String nodeColorColumnName;
    private String edgeWeightColumnName;
    private List<String> levelColumnNames;
    private Map<Integer, List> nodesMap = new HashMap<Integer, List>();
    private Map<Integer, List<Double>> nodePositionsMap = new HashMap<Integer, List<Double>>();
    private List<Double> nodeColorValues = new ArrayList<Double>();
    private List<List<Number>> edgesMappingsList = new ArrayList<List<Number>>();
    private Map<Integer, Double> angles = new HashMap<Integer, Double>();
    private Map<List, List> levelsPositionMap = new HashMap<List, List>();
    private List edgeControlPositionValues = new ArrayList();
    private double edgeBundlingDegree;
    private List<Map<Integer, String>> hierarchy = new ArrayList<Map<Integer, String>>();
    private Range<Color> nodeColorRange;
    private LogService logger;
    private boolean useStrength = true;
    private boolean useNodeColor = true;

    public RoundRussellComputation(int numberOfNodes, boolean useStrength, String nodeStrengthColumnName, List<String> levelColumnNames, String edgeWeightColumnName, boolean useNodeColor, String nodeColorColumnName, Range<Color> nodeColorRange, double betaCurvedValue, LogService logger) {
        this.useStrength = useStrength;
        this.nodeStrengthColumnName = nodeStrengthColumnName;
        this.levelColumnNames = levelColumnNames;
        this.edgeBundlingDegree = betaCurvedValue;
        this.edgeWeightColumnName = edgeWeightColumnName;
        this.useNodeColor = useNodeColor;
        this.nodeColorColumnName = nodeColorColumnName;
        this.nodeColorRange = nodeColorRange;
        this.logger = logger;
        int ii = 0;
        while (ii < levelColumnNames.size()) {
            if (!levelColumnNames.get(ii).equalsIgnoreCase("no_level_column")) {
                this.hierarchy.add(new HashMap());
            }
            ++ii;
        }
    }

    private void createEdge(int node1, int node2, Map attributes, boolean isUndirectedEdge) {
        double edgeWeight;
        ArrayList<Number> currentEdgeAttributes = new ArrayList<Number>();
        currentEdgeAttributes.add(node1);
        currentEdgeAttributes.add(node2);
        try {
            edgeWeight = Double.parseDouble(attributes.get(this.edgeWeightColumnName).toString());
        }
        catch (Exception exception) {
            edgeWeight = 1.0;
        }
        currentEdgeAttributes.add(edgeWeight);
        this.edgesMappingsList.add(currentEdgeAttributes);
    }

    public void addComment(String comment) {
    }

    public void addNode(int id, String label, Map attributes) {
        ArrayList<Object> nodeAttributes = new ArrayList<Object>();
        nodeAttributes.add(label);
        if (this.useStrength) {
            try {
                double currentNodeStrength = Double.parseDouble(attributes.get(this.nodeStrengthColumnName).toString());
                nodeAttributes.add(currentNodeStrength);
            }
            catch (NumberFormatException numberFormatException) {
                nodeAttributes.add(1.0);
            }
        } else {
            nodeAttributes.add(1.0);
        }
        if (this.useNodeColor) {
            try {
                double currentNodeColorValue = Double.parseDouble(attributes.get(this.nodeColorColumnName).toString());
                nodeAttributes.add(currentNodeColorValue);
                this.nodeColorValues.add(currentNodeColorValue);
            }
            catch (NumberFormatException numberFormatException) {
                nodeAttributes.add(1.0);
                this.nodeColorValues.add(1.0);
            }
        } else {
            nodeAttributes.add(1.0);
            this.nodeColorValues.add(1.0);
        }
        int ii = 0;
        while (ii < this.hierarchy.size()) {
            String levelValue = attributes.get(this.levelColumnNames.get(ii)).toString();
            this.hierarchy.get(ii).put(id, levelValue);
            ++ii;
        }
        this.nodesMap.put(id, nodeAttributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.createEdge(sourceNode, targetNode, attributes, false);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.createEdge(node1, node2, attributes, true);
    }

    public void finishedParsing() {
        this.normalizeNodesStrength();
        this.calculateAngles();
        this.calculateNodePositions();
        this.calculateLevelPositions(this.calculateLevelAngles(), this.hierarchy.size());
        this.calculateEdgeControlPoints();
        Collections.sort(this.edgeControlPositionValues, new Comparator(){

            public int compare(Object o1, Object o2) {
                double edgeWeight1 = 1.0 - Double.parseDouble(((List)o1).get(0).toString());
                double edgeWeight2 = 1.0 - Double.parseDouble(((List)o2).get(0).toString());
                return Double.compare(edgeWeight1, edgeWeight2);
            }
        });
        this.edgeControlPositionValues = this.normalizeEdgeControlPositionWeights();
        Collections.sort(this.edgeControlPositionValues, new Comparator(){

            public int compare(Object o1, Object o2) {
                int numberOfControlPoints1 = ((List)((List)o1).get(1)).size();
                int numberOfControlPoints2 = ((List)((List)o2).get(1)).size();
                double edgeWeight1 = 1.0 - Double.parseDouble(((List)o1).get(0).toString());
                double edgeWeight2 = 1.0 - Double.parseDouble(((List)o2).get(0).toString());
                if (numberOfControlPoints1 >= 4 && numberOfControlPoints2 < 4) {
                    return 1;
                }
                if (numberOfControlPoints1 < 4 && numberOfControlPoints2 >= 4) {
                    return -1;
                }
                if (numberOfControlPoints1 < 4 && numberOfControlPoints2 < 4) {
                    return Double.compare(edgeWeight1, edgeWeight2);
                }
                if (numberOfControlPoints1 >= 4 && numberOfControlPoints2 >= 4) {
                    return Double.compare(edgeWeight1, edgeWeight2);
                }
                return 0;
            }
        });
        this.generateOutputFileContent();
    }

    private void generateOutputFileContent() {
        Color nodeColor = DEFAULT_NODE_COLOR;
        this.psFileContent.append("/radius 800.0 def\n");
        boolean isNodeColoringPossible = false;
        if (!this.nodeColorColumnName.equalsIgnoreCase("No Node Color")) {
            try {
                this.nodeColorInterpolator = new ColorInterpolator(this.nodeColorValues, this.nodeColorRange);
                isNodeColoringPossible = true;
            }
            catch (InputRangeException e) {
                this.logger.log(1, "Node color attribute values have to be sufficiently distinct. In the current sample max & min for node color attribute is the same. Default node color assumed." + e.getMessage(), (Throwable)e);
            }
        }
        for (Map.Entry<Integer, List<Double>> positionMapEntry : this.nodePositionsMap.entrySet()) {
            String nodeLabel = this.nodesMap.get(positionMapEntry.getKey()).get(0).toString();
            String nodeStrength = this.nodesMap.get(positionMapEntry.getKey()).get(1).toString();
            double nodecolorValue = Double.parseDouble(this.nodesMap.get(positionMapEntry.getKey()).get(2).toString());
            String xPosition = ((Object)positionMapEntry.getValue().get(0)).toString();
            String yPosition = ((Object)positionMapEntry.getValue().get(1)).toString();
            if (!"No Node Color".equalsIgnoreCase(this.nodeColorColumnName) && isNodeColoringPossible) {
                nodeColor = this.nodeColorInterpolator.interpolate(nodecolorValue);
            }
            this.psFileContent.append(String.valueOf((double)nodeColor.getRed() / 255.0) + " " + (double)nodeColor.getGreen() / 255.0 + " " + (double)nodeColor.getBlue() / 255.0 + " " + "(" + nodeLabel + ")" + " " + nodeStrength + " " + xPosition + " " + yPosition + " node\n");
        }
        Iterator normalizedEdgesControlPositionsIterator = this.edgeControlPositionValues.iterator();
        while (normalizedEdgesControlPositionsIterator.hasNext()) {
            StringBuilder arrayPoints = new StringBuilder();
            List currentEdge = (List)normalizedEdgesControlPositionsIterator.next();
            for (List currentEdgePositions : (List)currentEdge.get(1)) {
                arrayPoints.append(currentEdgePositions.get(0) + " " + currentEdgePositions.get(1) + " ");
            }
            this.psFileContent.append("[ " + arrayPoints + " ] " + currentEdge.get(0).toString() + " edge\n");
        }
        int level = 0;
        while (level < this.hierarchy.size()) {
            List<Double> dividers = this.calculateDividers(this.hierarchy.get(level));
            this.psFileContent.append("[ ");
            Iterator<Double> dividersIterator = dividers.iterator();
            while (dividersIterator.hasNext()) {
                this.psFileContent.append(String.valueOf(((Object)dividersIterator.next()).toString()) + " ");
            }
            this.psFileContent.append("] " + level + " level\n");
            ++level;
        }
        this.psFileContent.append("grestore\n");
    }

    private List<Double> calculateDividers(Map<Integer, String> levelMap) {
        ArrayList<Double> calculatedDividers = new ArrayList<Double>();
        TreeSet<Object> sortedNodesByAngles = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Double)RoundRussellComputation.this.angles.get(o1)).compareTo((Double)RoundRussellComputation.this.angles.get(o2));
            }
        });
        sortedNodesByAngles.addAll(this.angles.keySet());
        ArrayList<Object> sortedNodesByAnglesList = new ArrayList<Object>();
        sortedNodesByAnglesList.addAll(sortedNodesByAngles);
        sortedNodesByAnglesList.add((Integer)sortedNodesByAngles.first());
        int previousNode = (Integer)sortedNodesByAnglesList.get(0);
        Iterator iterator = sortedNodesByAnglesList.iterator();
        while (iterator.hasNext()) {
            int currentNode = Integer.parseInt(iterator.next().toString());
            if (!levelMap.get(currentNode).equals(levelMap.get(previousNode))) {
                double newAngle = this.calculateBetweenAngle(this.angles.get(previousNode), this.angles.get(currentNode));
                calculatedDividers.add(newAngle);
            }
            previousNode = currentNode;
        }
        return calculatedDividers;
    }

    private List<List> normalizeEdgeControlPositionWeights() {
        ArrayList edgeWeightValues = new ArrayList();
        ArrayList<List> normalizedEdgeControlPositionWeights = new ArrayList<List>();
        Iterator edgeWeightValuesIterator = this.edgeControlPositionValues.iterator();
        while (edgeWeightValuesIterator.hasNext()) {
            edgeWeightValues.add(((List)edgeWeightValuesIterator.next()).get(0));
        }
        double maxWeight = Double.parseDouble(((Comparable)Collections.max(edgeWeightValues)).toString());
        double minWeight = Double.parseDouble(((Comparable)Collections.min(edgeWeightValues)).toString());
        double normalizedMaxWeight = Math.log(maxWeight + 1.0);
        double normalizedMinWeight = Math.log(minWeight + 1.0);
        for (List currentEdgeValues : this.edgeControlPositionValues) {
            double currentEdgeNormalizedWeight = this.getCurrentEdgeNormalizedWeight(normalizedMaxWeight, normalizedMinWeight, currentEdgeValues);
            ArrayList<Double> currentNormalizedEdgeControlPositionValues = new ArrayList<Double>();
            currentNormalizedEdgeControlPositionValues.add(currentEdgeNormalizedWeight);
            currentNormalizedEdgeControlPositionValues.add((Double)currentEdgeValues.get(1));
            normalizedEdgeControlPositionWeights.add(currentNormalizedEdgeControlPositionValues);
        }
        return normalizedEdgeControlPositionWeights;
    }

    private double getCurrentEdgeNormalizedWeight(double normalizedMaxWeight, double normalizedMinWeight, List edgeValues) {
        double currentEdgeWeight;
        try {
            currentEdgeWeight = Double.parseDouble(edgeValues.get(0).toString());
        }
        catch (Exception exception) {
            currentEdgeWeight = 1.0;
        }
        double currentNormalizedEdgeWeight = normalizedMaxWeight - normalizedMinWeight == 0.0 ? 0.0 : (Math.log(currentEdgeWeight + 1.0) - normalizedMinWeight) / (normalizedMaxWeight - normalizedMinWeight);
        return currentNormalizedEdgeWeight;
    }

    private void calculateEdgeControlPoints() {
        Iterator<List<Number>> edgeMappingsIterator = this.edgesMappingsList.iterator();
        while (edgeMappingsIterator.hasNext()) {
            ArrayList<Object> currentEdgeControlPositionValues = new ArrayList<Object>();
            List<Number> currentEdge = edgeMappingsIterator.next();
            int sourceNode = Integer.parseInt(currentEdge.get(0).toString());
            int targetNode = Integer.parseInt(currentEdge.get(1).toString());
            double edgeWeight = Double.parseDouble(currentEdge.get(2).toString());
            currentEdgeControlPositionValues.add(edgeWeight);
            List<List<Double>> controlPoints = this.calculateControlPoints(sourceNode, targetNode);
            currentEdgeControlPositionValues.add(controlPoints);
            this.edgeControlPositionValues.add(currentEdgeControlPositionValues);
        }
    }

    private List<List<Double>> calculateControlPoints(int sourceNode, int targetNode) {
        List<List> ancestors = this.calculateAncestorHierarchy(sourceNode, targetNode);
        ArrayList<List> ancestorPositions = new ArrayList<List>();
        ArrayList<List<Double>> controlPositions = new ArrayList<List<Double>>();
        Iterator<List> ancestorsIterator = ancestors.iterator();
        while (ancestorsIterator.hasNext()) {
            List currentAncestorsPositionMappings = this.levelsPositionMap.get(ancestorsIterator.next());
            ancestorPositions.add(currentAncestorsPositionMappings);
        }
        controlPositions.add(this.nodePositionsMap.get(sourceNode));
        controlPositions.addAll(ancestorPositions);
        controlPositions.add(this.nodePositionsMap.get(targetNode));
        return this.adjustControlPositions(controlPositions, this.edgeBundlingDegree);
    }

    private List<List<Double>> adjustControlPositions(List<List<Double>> controlPositions, double curveBetaValue) {
        ArrayList<List<Double>> adjustedControlPositions = new ArrayList<List<Double>>();
        int numberofControlPositions = controlPositions.size();
        double x0 = controlPositions.get(0).get(0);
        double y0 = controlPositions.get(0).get(1);
        double xLast = controlPositions.get(numberofControlPositions - 1).get(0);
        double yLast = controlPositions.get(numberofControlPositions - 1).get(1);
        double xDifference = xLast - x0;
        double yDifference = yLast - y0;
        int index = 0;
        for (List<Double> currentControlPositionPair : controlPositions) {
            ArrayList<Double> currentAdjustedControlPositionPair = new ArrayList<Double>();
            double xCurrent = Double.parseDouble(((Object)currentControlPositionPair.get(0)).toString());
            double yCurrent = Double.parseDouble(((Object)currentControlPositionPair.get(1)).toString());
            double xPrime = curveBetaValue * xCurrent + (1.0 - curveBetaValue) * (x0 + (double)index * xDifference / (double)(numberofControlPositions - 1));
            double yPrime = curveBetaValue * yCurrent + (1.0 - curveBetaValue) * (y0 + (double)index * yDifference / (double)(numberofControlPositions - 1));
            currentAdjustedControlPositionPair.add(xPrime);
            currentAdjustedControlPositionPair.add(yPrime);
            adjustedControlPositions.add(currentAdjustedControlPositionPair);
            ++index;
        }
        return adjustedControlPositions;
    }

    private List<List> calculateAncestorHierarchy(int sourceNode, int targetNode) {
        ArrayList sourceAncestry = new ArrayList();
        ArrayList<List> targetAncestry = new ArrayList<List>();
        int level = 0;
        while (level < this.hierarchy.size()) {
            String targetCommunity;
            String sourceCommunity = this.hierarchy.get(level).get(sourceNode);
            if (sourceCommunity.equalsIgnoreCase(targetCommunity = this.hierarchy.get(level).get(targetNode))) {
                ArrayList<List> ancestorHierarchy = new ArrayList<List>();
                ArrayList<Object> ancestor = new ArrayList<Object>();
                if (sourceAncestry.isEmpty()) {
                    ancestor.add(level);
                    ancestor.add(sourceCommunity);
                    ancestorHierarchy.add(ancestor);
                    return ancestorHierarchy;
                }
                ancestorHierarchy.addAll(sourceAncestry);
                ancestorHierarchy.addAll(this.reverseList(targetAncestry));
                return ancestorHierarchy;
            }
            ArrayList<Object> temporaryAncestorElement = new ArrayList<Object>();
            temporaryAncestorElement.add(level);
            temporaryAncestorElement.add(sourceCommunity);
            sourceAncestry.add(temporaryAncestorElement);
            ArrayList<Object> temporaryAncestorElement2 = new ArrayList<Object>();
            temporaryAncestorElement2.add(level);
            temporaryAncestorElement2.add(targetCommunity);
            targetAncestry.add(temporaryAncestorElement2);
            ++level;
        }
        ArrayList<List> returnedAncestorHierarchy = new ArrayList<List>();
        returnedAncestorHierarchy.addAll(sourceAncestry);
        returnedAncestorHierarchy.addAll(this.reverseList(targetAncestry));
        return returnedAncestorHierarchy;
    }

    private List<List> reverseList(List<List> sequence) {
        Collections.reverse(sequence);
        return sequence;
    }

    private void calculateLevelPositions(Map<List, Double> levelAngles, int totalLevels) {
        Iterator<Map.Entry<List, Double>> levelAnglesIterator = levelAngles.entrySet().iterator();
        while (levelAnglesIterator.hasNext()) {
            ArrayList<Double> levelPositionMapValue = new ArrayList<Double>();
            Map.Entry<List, Double> levelAngleEntry = levelAnglesIterator.next();
            double radius = ((double)totalLevels - Double.parseDouble(levelAngleEntry.getKey().get(0).toString()) - 1.0) * 800.0 / (double)totalLevels;
            levelPositionMapValue.addAll(this.convertToCartesianSystem(radius, Double.parseDouble(((Object)levelAngleEntry.getValue()).toString())));
            this.levelsPositionMap.put(levelAngleEntry.getKey(), levelPositionMapValue);
        }
    }

    private Map<List, Double> calculateLevelAngles() {
        HashMap<List, Double> levelAngles = new HashMap<List, Double>();
        TreeSet<Object> sortedNodesByAngles = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Double)RoundRussellComputation.this.angles.get(o1)).compareTo((Double)RoundRussellComputation.this.angles.get(o2));
            }
        });
        sortedNodesByAngles.addAll(this.angles.keySet());
        ArrayList<Object> sortedNodesByAnglesList = new ArrayList<Object>();
        sortedNodesByAnglesList.addAll(sortedNodesByAngles);
        sortedNodesByAnglesList.add((Integer)sortedNodesByAngles.first());
        int level = 0;
        while (level < this.hierarchy.size()) {
            double previousAngle = 0.0;
            int previousNode = Integer.parseInt(((Integer)sortedNodesByAnglesList.get(0)).toString());
            Iterator iterator = sortedNodesByAnglesList.iterator();
            while (iterator.hasNext()) {
                int currentNode = Integer.parseInt(iterator.next().toString());
                if (!this.hierarchy.get(level).get(currentNode).equals(this.hierarchy.get(level).get(previousNode))) {
                    ArrayList<Object> levelAngleKeyComposite = new ArrayList<Object>();
                    double newAngle = this.calculateBetweenAngle(this.angles.get(previousNode), this.angles.get(currentNode));
                    levelAngleKeyComposite.add(level);
                    levelAngleKeyComposite.add(this.hierarchy.get(level).get(previousNode));
                    levelAngles.put(levelAngleKeyComposite, this.calculateBetweenAngle(previousAngle, newAngle));
                    previousAngle = newAngle;
                }
                previousNode = currentNode;
            }
            ++level;
        }
        return levelAngles;
    }

    private double calculateBetweenAngle(Double start, Double end) {
        if (end < start) {
            end = end + 360.0;
        }
        return (start + end) / 2.0 % 360.0;
    }

    private void calculateNodePositions() {
        for (Map.Entry<Integer, Double> angleEntry : this.angles.entrySet()) {
            List<Object> positionValues = new ArrayList();
            double currentAnglesInDegrees = Double.parseDouble(((Object)angleEntry.getValue()).toString());
            positionValues = this.convertToCartesianSystem(800.0, currentAnglesInDegrees);
            this.nodePositionsMap.put(angleEntry.getKey(), positionValues);
        }
    }

    private List<Double> convertToCartesianSystem(double radius, double currentAnglesInDegrees) {
        ArrayList<Double> positionValues = new ArrayList<Double>();
        double currentAnglesInRadians = Math.toRadians(currentAnglesInDegrees);
        positionValues.add(radius * Math.cos(currentAnglesInRadians));
        positionValues.add(radius * Math.sin(currentAnglesInRadians));
        return positionValues;
    }

    private void calculateAngles() {
        int indexCounter = 0;
        ArrayList<Integer> sortedNodesForAnglesList = new ArrayList<Integer>();
        sortedNodesForAnglesList.addAll(this.nodesMap.keySet());
        Collections.sort(sortedNodesForAnglesList, new Comparator(){

            public int compare(Object n1, Object n2) {
                int i = RoundRussellComputation.this.hierarchy.size() - 1;
                while (i > -1) {
                    if (!((String)((Map)RoundRussellComputation.this.hierarchy.get(i)).get(n1)).equalsIgnoreCase((String)((Map)RoundRussellComputation.this.hierarchy.get(i)).get(n2))) {
                        return ((String)((Map)RoundRussellComputation.this.hierarchy.get(i)).get(n1)).compareToIgnoreCase((String)((Map)RoundRussellComputation.this.hierarchy.get(i)).get(n2));
                    }
                    --i;
                }
                return ((List)RoundRussellComputation.this.nodesMap.get(n1)).get(0).toString().compareToIgnoreCase(((List)RoundRussellComputation.this.nodesMap.get(n2)).get(0).toString());
            }
        });
        double numberOfNodes = sortedNodesForAnglesList.size();
        Iterator sortedNodesForAnglesIterator = sortedNodesForAnglesList.iterator();
        while (sortedNodesForAnglesIterator.hasNext()) {
            double angle = ((double)indexCounter + 0.5) * 360.0 / numberOfNodes;
            this.angles.put((Integer)sortedNodesForAnglesIterator.next(), angle);
            ++indexCounter;
        }
    }

    private void normalizeNodesStrength() {
        List nodeValues;
        ArrayList nodeStrengthValues = new ArrayList();
        Iterator<List> nodeValuesIterator = this.nodesMap.values().iterator();
        HashMap<Integer, List> nodesMapOutput = new HashMap<Integer, List>();
        while (nodeValuesIterator.hasNext()) {
            nodeValues = nodeValuesIterator.next();
            nodeStrengthValues.add(nodeValues.get(1));
        }
        Double maxStrength = Double.parseDouble(((Comparable)Collections.max(nodeStrengthValues)).toString());
        Double minStrength = Double.parseDouble(((Comparable)Collections.min(nodeStrengthValues)).toString());
        Double normalizedMaxStrength = Math.log(maxStrength + 1.0);
        Double normalizedMinStrength = Math.log(minStrength + 1.0);
        for (Map.Entry<Integer, List> thisEntry : this.nodesMap.entrySet()) {
            Integer nodeID = thisEntry.getKey();
            nodeValues = thisEntry.getValue();
            Double normalizedNodeCurrentStrength = this.getCurrentNodeNormalizedStrength(normalizedMaxStrength, normalizedMinStrength, nodeValues);
            nodeValues.set(1, normalizedNodeCurrentStrength);
            nodesMapOutput.put(nodeID, nodeValues);
        }
    }

    private Double getCurrentNodeNormalizedStrength(Double normalizedMaxStrength, Double normalizedMinStrength, List nodeValues) {
        Double nodeCurrentStrength;
        try {
            nodeCurrentStrength = Double.parseDouble(nodeValues.get(1).toString());
        }
        catch (Exception exception) {
            nodeCurrentStrength = 1.0;
        }
        Double normalizedNodeCurrentStrength = normalizedMaxStrength - normalizedMinStrength == 0.0 ? Double.valueOf(0.0) : Double.valueOf((Math.log(nodeCurrentStrength + 1.0) - normalizedMinStrength) / (normalizedMaxStrength - normalizedMinStrength));
        return normalizedNodeCurrentStrength;
    }

    public Range<Double> getNodeColorValueRange() {
        double minimumColorValue = Collections.min(this.nodeColorValues);
        double maximumColorValue = Collections.max(this.nodeColorValues);
        return new Range<Double>(minimumColorValue, maximumColorValue);
    }

    public boolean haltParsingNow() {
        return false;
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
    }

    public void setNodeCount(int numberOfNodes) {
    }

    public void setNodeSchema(LinkedHashMap schema) {
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
    }
}

