/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.interpolation;

import edu.iu.nwb.visualization.roundrussell.interpolation.InputRangeException;
import edu.iu.nwb.visualization.roundrussell.interpolation.Interpolator;
import edu.iu.nwb.visualization.roundrussell.interpolation.InterpolatorInversionException;
import edu.iu.nwb.visualization.roundrussell.interpolation.LinearInterpolator;
import edu.iu.nwb.visualization.roundrussell.utility.Averager;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import edu.iu.nwb.visualization.roundrussell.utility.RelativeDifferenceLimit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorInterpolator
implements Interpolator<Color> {
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final double INVERT_TOLERANCE = 0.01;
    private LinearInterpolator redInterpolator;
    private LinearInterpolator greenInterpolator;
    private LinearInterpolator blueInterpolator;

    public ColorInterpolator(Collection<Double> colorQuantities, Range<Color> interpolatedRange) throws InputRangeException {
        float[] minimumColorComponents = new float[3];
        interpolatedRange.getMin().getColorComponents(minimumColorComponents);
        float[] maximumColorComponents = new float[3];
        interpolatedRange.getMax().getColorComponents(maximumColorComponents);
        this.redInterpolator = new LinearInterpolator(colorQuantities, new Range<Double>(Double.valueOf(minimumColorComponents[0]), Double.valueOf(maximumColorComponents[0])));
        this.greenInterpolator = new LinearInterpolator(colorQuantities, new Range<Double>(Double.valueOf(minimumColorComponents[1]), Double.valueOf(maximumColorComponents[1])));
        this.blueInterpolator = new LinearInterpolator(colorQuantities, new Range<Double>(Double.valueOf(minimumColorComponents[2]), Double.valueOf(maximumColorComponents[2])));
    }

    @Override
    public Color interpolate(double colorQuantity) {
        float red = this.redInterpolator.interpolate(colorQuantity).floatValue();
        float green = this.greenInterpolator.interpolate(colorQuantity).floatValue();
        float blue = this.blueInterpolator.interpolate(colorQuantity).floatValue();
        return new Color(red, green, blue);
    }

    @Override
    public double invert(Color color) throws InterpolatorInversionException {
        RelativeDifferenceLimit relativeDifferenceLimit = new RelativeDifferenceLimit(0.01);
        List<Double> inversionSamples = this.calculateColorInversionSamples(color);
        if (relativeDifferenceLimit.isPairwiseSatisfiedBy(inversionSamples)) {
            return Averager.mean(inversionSamples.toArray(new Double[0]));
        }
        String message = "Unexpected error: Inverting interpolation of the Color " + color + " generated intolerable differences between the pre-image " + "red, green, and blue dimensions.  These values should be " + "nearly equal, up to floating-point arithmetic error.  ";
        message = String.valueOf(message) + "Found these samples: ";
        for (double inversionSample : inversionSamples) {
            message = String.valueOf(message) + inversionSample + " ";
        }
        message = String.valueOf(message) + ".";
        throw new InterpolatorInversionException(message);
    }

    private List<Double> calculateColorInversionSamples(Color color) throws InterpolatorInversionException {
        float[] colorComponents = new float[3];
        color.getColorComponents(colorComponents);
        ArrayList<Double> inversionSamples = new ArrayList<Double>();
        ArrayList<InterpolatorInversionException> exceptions = new ArrayList<InterpolatorInversionException>();
        try {
            double invertedRed = this.redInterpolator.invert(Double.valueOf(colorComponents[0]));
            inversionSamples.add(invertedRed);
        }
        catch (InterpolatorInversionException e) {
            exceptions.add(e);
        }
        try {
            double invertedGreen = this.greenInterpolator.invert(Double.valueOf(colorComponents[1]));
            inversionSamples.add(invertedGreen);
        }
        catch (InterpolatorInversionException e) {
            exceptions.add(e);
        }
        try {
            double invertedBlue = this.blueInterpolator.invert(Double.valueOf(colorComponents[2]));
            inversionSamples.add(invertedBlue);
        }
        catch (InterpolatorInversionException e) {
            exceptions.add(e);
        }
        if (inversionSamples.isEmpty()) {
            String message = "Unexpected error: Inversion failed for all three color coordinates. This should only happen if " + this + " is trying " + " to interpolate into a degenerate Color Range. ";
            message = String.valueOf(message) + "Caught these exceptions in the attempt:\n";
            for (Exception exception : exceptions) {
                message = String.valueOf(message) + "  " + exception.getMessage() + "\n";
            }
            throw new InterpolatorInversionException(message);
        }
        return inversionSamples;
    }

    @Override
    public List<Color> interpolate(List<Double> values) {
        ArrayList<Color> interpolatedValues = new ArrayList<Color>();
        for (double value : values) {
            Color interpolatedValue = this.interpolate(value);
            interpolatedValues.add(interpolatedValue);
        }
        return interpolatedValues;
    }
}

