/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.interpolation;

import edu.iu.nwb.visualization.roundrussell.interpolation.InputRangeException;
import edu.iu.nwb.visualization.roundrussell.interpolation.Interpolator;
import edu.iu.nwb.visualization.roundrussell.interpolation.InterpolatorInversionException;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearInterpolator
implements Interpolator<Double> {
    private Range<Double> inRange;
    private Range<Double> outRange;

    public LinearInterpolator(Collection<Double> inValues, Range<Double> outRange) throws InputRangeException {
        this(Range.calculateRange(inValues), outRange);
    }

    public LinearInterpolator(Range<Double> inRange, Range<Double> outRange) throws InputRangeException {
        if (inRange.getMin().equals(inRange.getMax())) {
            throw new InputRangeException(inRange);
        }
        this.inRange = inRange;
        this.outRange = outRange;
    }

    @Override
    public Double interpolate(double value) {
        return LinearInterpolator.interpolate(value, this.inRange, this.outRange);
    }

    private static double interpolate(double value, Range<Double> inRange, Range<Double> outRange) {
        return LinearInterpolator.interpolate(value, inRange.getMin(), inRange.getMax(), outRange.getMin(), outRange.getMax());
    }

    private static double interpolate(double in, double inMin, double inMax, double outMin, double outMax) {
        if (inMax - inMin == 0.0) {
            throw new RuntimeException("Unexpected error: Trying to interpolate from an input range with zero length.");
        }
        return outMin + (in - inMin) * (outMax - outMin) / (inMax - inMin);
    }

    @Override
    public double invert(Double value) throws InterpolatorInversionException {
        LinearInterpolator inverseInterpolator = LinearInterpolator.createInverse(this);
        return (Double)inverseInterpolator.interpolate(value);
    }

    private static LinearInterpolator createInverse(LinearInterpolator interpolator) throws InterpolatorInversionException {
        try {
            Range<Double> inRange = interpolator.getInRange();
            Range<Double> outRange = interpolator.getOutRange();
            return new LinearInterpolator(outRange, inRange);
        }
        catch (InputRangeException e) {
            throw new InterpolatorInversionException(e);
        }
    }

    public Range<Double> getInRange() {
        return this.inRange;
    }

    public Range<Double> getOutRange() {
        return this.outRange;
    }

    @Override
    public List<Double> interpolate(List<Double> values) {
        ArrayList<Double> interpolatedValues = new ArrayList<Double>();
        for (double value : values) {
            double interpolatedValue = this.interpolate(value);
            interpolatedValues.add(interpolatedValue);
        }
        return interpolatedValues;
    }
}

