/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.legend;

import edu.iu.nwb.visualization.roundrussell.RoundRussellAlgorithm;
import edu.iu.nwb.visualization.roundrussell.legend.LegendComponent;
import edu.iu.nwb.visualization.roundrussell.legend.UnsignedZeroDecimalFormat;
import edu.iu.nwb.visualization.roundrussell.utility.Range;
import java.awt.Color;
import org.antlr.stringtemplate.StringTemplate;

public class ColorLegend
implements LegendComponent {
    public static final int GRADIENT_RESOLUTION = 1;
    public static final double EXTREMA_LABEL_BRIGHTNESS = 0.0;
    public static final double EXTREMA_LABEL_FONT_SIZE = 8.0;
    public static final double TYPE_LABEL_BRIGHTNESS = 0.0;
    public static final double TYPE_LABEL_FONT_SIZE = 10.0;
    public static final double SCALING_LABEL_BRIGHTNESS = 0.5;
    public static final double KEY_LABEL_BRIGHTNESS = 0.5;
    public static final double KEY_LABEL_FONT_SIZE = 8.0;
    public static final String FONT_NAME = "Garamond";
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    private Range<Double> rawRange;
    private String scalingLabel;
    private double rawMidColorQuantity;
    private Range<Color> interpolatedRange;
    private double lowerLeftX;
    private double lowerLeftY;
    private double gradientWidth;
    private double gradientHeight;
    private String typeLabel;
    private String keyLabel;
    private boolean hasPrintedDefinitions;

    public ColorLegend(Range<Double> rawRange, String scaling, double rawMidColorQuantity, Range<Color> interpolatedRange, String typeLabel, String keyLabel, double lowerLeftX, double lowerLeftY, double width, double height) {
        this.rawRange = rawRange;
        this.scalingLabel = scaling;
        this.rawMidColorQuantity = rawMidColorQuantity;
        this.interpolatedRange = interpolatedRange;
        this.typeLabel = typeLabel;
        this.keyLabel = keyLabel;
        this.lowerLeftX = lowerLeftX;
        this.lowerLeftY = lowerLeftY;
        this.gradientWidth = width;
        this.gradientHeight = height;
        this.hasPrintedDefinitions = false;
    }

    @Override
    public String toPostScript() {
        String s = "";
        if (!this.hasPrintedDefinitions) {
            StringTemplate definitionsTemplate = RoundRussellAlgorithm.group.getInstanceOf("colorLegendDefinitions");
            s = String.valueOf(s) + definitionsTemplate.toString();
            this.hasPrintedDefinitions = true;
        }
        StringTemplate invocationTemplate = RoundRussellAlgorithm.group.getInstanceOf("colorLegend");
        invocationTemplate.setAttribute("x", (Object)this.lowerLeftX);
        invocationTemplate.setAttribute("y", (Object)this.lowerLeftY);
        invocationTemplate.setAttribute("gradientWidth", (Object)this.gradientWidth);
        invocationTemplate.setAttribute("gradientHeight", (Object)this.gradientHeight);
        invocationTemplate.setAttribute("gradientResolution", 1);
        float[] minColorComponents = new float[3];
        this.interpolatedRange.getMin().getColorComponents(minColorComponents);
        invocationTemplate.setAttribute("minColorRed", (Object)Float.valueOf(minColorComponents[0]));
        invocationTemplate.setAttribute("minColorGreen", (Object)Float.valueOf(minColorComponents[1]));
        invocationTemplate.setAttribute("minColorBlue", (Object)Float.valueOf(minColorComponents[2]));
        float[] maxColorComponents = new float[3];
        this.interpolatedRange.getMax().getColorComponents(maxColorComponents);
        invocationTemplate.setAttribute("maxColorRed", (Object)Float.valueOf(maxColorComponents[0]));
        invocationTemplate.setAttribute("maxColorGreen", (Object)Float.valueOf(maxColorComponents[1]));
        invocationTemplate.setAttribute("maxColorBlue", (Object)Float.valueOf(maxColorComponents[2]));
        UnsignedZeroDecimalFormat doubleFormatter = UnsignedZeroDecimalFormat.createDecimalFormatOver(this.rawRange.getMin(), this.rawMidColorQuantity, this.rawRange.getMax());
        invocationTemplate.setAttribute("minLabel", (Object)doubleFormatter.format(this.rawRange.getMin()));
        invocationTemplate.setAttribute("midLabel", (Object)doubleFormatter.format(this.rawMidColorQuantity));
        invocationTemplate.setAttribute("maxLabel", (Object)doubleFormatter.format(this.rawRange.getMax()));
        invocationTemplate.setAttribute("extremaLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("extremaLabelFontSize", (Object)8.0);
        invocationTemplate.setAttribute("typeLabel", (Object)this.typeLabel);
        invocationTemplate.setAttribute("typeLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("typeLabelFontSize", (Object)10.0);
        invocationTemplate.setAttribute("scalingLabel", (Object)"");
        invocationTemplate.setAttribute("scalingLabelBrightness", (Object)0.5);
        invocationTemplate.setAttribute("keyLabel", (Object)this.keyLabel);
        invocationTemplate.setAttribute("keyLabelBrightness", (Object)0.5);
        invocationTemplate.setAttribute("keyLabelFontSize", (Object)8.0);
        invocationTemplate.setAttribute("fontName", (Object)FONT_NAME);
        s = String.valueOf(s) + invocationTemplate.toString();
        return s;
    }

    public Range<Double> getRawRange() {
        return this.rawRange;
    }
}

