/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.legend;

import edu.iu.nwb.visualization.roundrussell.utility.RelativeDifferenceLimit;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class UnsignedZeroDecimalFormat {
    public static final String UNSIGNED_ZERO = "0";
    public static final String NEGATIVE_ZERO = "-0";
    public static final String INTEGER_DIGITS_SEPARATOR = ",";
    public static final double TOLERANCE = 1.0;
    public static final int ATTEMPT_LIMIT = 8;
    private Format formatter;

    public UnsignedZeroDecimalFormat(Format formatter) {
        this.formatter = formatter;
    }

    public String format(double value) {
        String formattedValue = this.formatter.format(value);
        if (NEGATIVE_ZERO.equals(formattedValue)) {
            return UNSIGNED_ZERO;
        }
        return formattedValue;
    }

    protected static UnsignedZeroDecimalFormat createDecimalFormatOver(double ... values) {
        DecimalFormat formatter = new DecimalFormat();
        if (!UnsignedZeroDecimalFormat.isStrictlyIncreasing(values)) {
            throw new IllegalArgumentException("Error: The given values must be strictly increasing.");
        }
        RelativeDifferenceLimit relativeDifferenceLimit = new RelativeDifferenceLimit(1.0);
        int maximumNumberOfFractionDigits = 0;
        int ii = 0;
        while (ii < 8) {
            formatter.setMaximumFractionDigits(maximumNumberOfFractionDigits);
            double[] approximateValues = new double[values.length];
            int jj = 0;
            while (jj < values.length) {
                String formattedValue = formatter.format(values[jj]);
                approximateValues[jj] = Double.valueOf(formattedValue.replace(INTEGER_DIGITS_SEPARATOR, ""));
                ++jj;
            }
            if (UnsignedZeroDecimalFormat.isStrictlyIncreasing(approximateValues) && relativeDifferenceLimit.isSatisfiedBetween(UnsignedZeroDecimalFormat.toList(values), UnsignedZeroDecimalFormat.toList(approximateValues))) {
                return new UnsignedZeroDecimalFormat(formatter);
            }
            ++maximumNumberOfFractionDigits;
            ++ii;
        }
        return new UnsignedZeroDecimalFormat(formatter);
    }

    private static boolean isStrictlyIncreasing(double ... values) {
        int jj = 0;
        while (jj < values.length - 1) {
            if (!(values[jj] < values[jj + 1])) {
                return false;
            }
            ++jj;
        }
        return true;
    }

    private static List<Double> toList(double[] values) {
        ArrayList<Double> list = new ArrayList<Double>();
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            list.add(value);
            ++n2;
        }
        return list;
    }
}

